/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2.event;

import com.elenai.elenaidodge2.capability.InvincibleCapability;
import com.elenai.elenaidodge2.capability.PlayerInvincibilityProvider;
import com.elenai.elenaidodge2.config.ED2CommonConfig;
import com.elenai.elenaidodge2.networking.ED2Messages;
import com.elenai.elenaidodge2.networking.messages.ConfigSyncSTCPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="elenaidodge2")
public class CommonEvents {
    @SubscribeEvent
    public static void playerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            event.player.getCapability(PlayerInvincibilityProvider.PLAYER_INVINCIBILITY).ifPresent(i -> {
                if (i.getInvincibility() > 0) {
                    i.subInvincibility(1);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerHit(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            player.getCapability(PlayerInvincibilityProvider.PLAYER_INVINCIBILITY).ifPresent(i -> {
                if (i.getInvincibility() > 0 && (event.getSource() == event.getEntity().m_9236_().m_269111_().m_269254_() || event.getSource().m_7639_() instanceof Mob || event.getSource().m_7639_() instanceof ServerPlayer)) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        Level level = event.getLevel();
        if (!level.f_46443_ && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ED2Messages.sendToPlayer(new ConfigSyncSTCPacket((Boolean)ED2CommonConfig.DODGE_WHILST_AIRBORNE.get(), (Integer)ED2CommonConfig.COOLDOWN_TIME.get(), (Integer)ED2CommonConfig.DODGE_COST.get(), (Double)ED2CommonConfig.DODGE_STRENGTH.get(), (Double)ED2CommonConfig.DODGE_HEIGHT.get()), player);
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerInvincibilityProvider.PLAYER_INVINCIBILITY).isPresent()) {
            event.addCapability(new ResourceLocation("elenaidodge2", "properties"), (ICapabilityProvider)new PlayerInvincibilityProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerInvincibilityProvider.PLAYER_INVINCIBILITY).ifPresent(oldStore -> event.getOriginal().getCapability(PlayerInvincibilityProvider.PLAYER_INVINCIBILITY).ifPresent(newStore -> newStore.copyFrom((InvincibleCapability)oldStore)));
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(InvincibleCapability.class);
    }
}

