/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.util.RegistryUtil;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ForagingRecipe
implements Recipe<Container> {
    public ResourceLocation id;
    public ItemStack result;
    public Ingredient block;

    public ForagingRecipe(ResourceLocation id, ItemStack output, Ingredient block) {
        this.id = id;
        this.result = output;
        this.block = block;
    }

    public boolean m_5818_(@NotNull Container pContainer, @NotNull Level pLevel) {
        return false;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container pContainer, @NotNull RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EidolonRecipes.FORAGING_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)EidolonRecipes.FORAGING_TYPE.get();
    }

    public JsonObject toJson() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "eidolon:athame_foraging");
        jsonobject.add("block", this.block.m_43942_());
        JsonObject resultObj = new JsonObject();
        resultObj.addProperty("item", RegistryUtil.getRegistryName(this.result.m_41720_()).toString());
        int count = this.result.m_41613_();
        if (count > 1) {
            resultObj.addProperty("count", (Number)count);
        }
        jsonobject.add("output", (JsonElement)resultObj);
        return jsonobject;
    }

    public static class Serializer
    implements RecipeSerializer<ForagingRecipe> {
        @NotNull
        public ForagingRecipe fromJson(@NotNull ResourceLocation pId, @NotNull JsonObject pJson) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"output"));
            Ingredient block = Ingredient.m_43917_((JsonElement)pJson.get("block"));
            return new ForagingRecipe(pId, output, block);
        }

        public ForagingRecipe fromNetwork(@NotNull ResourceLocation pId, @NotNull FriendlyByteBuf pBuffer) {
            return new ForagingRecipe(pId, pBuffer.m_130267_(), Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
        }

        public void toNetwork(@NotNull FriendlyByteBuf pBuffer, @NotNull ForagingRecipe pRecipe) {
            pBuffer.m_130055_(pRecipe.result);
            pRecipe.block.m_43923_(pBuffer);
        }
    }
}

