/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.client.forge;

import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import samebutdifferent.ecologics.client.EcologicsClient;
import samebutdifferent.ecologics.client.model.CamelModel;
import samebutdifferent.ecologics.client.model.CoconutCrabModel;
import samebutdifferent.ecologics.client.model.PenguinModel;
import samebutdifferent.ecologics.client.model.SquirrelModel;
import samebutdifferent.ecologics.entity.ModBoat;
import samebutdifferent.ecologics.registry.ModBlockEntityTypes;
import samebutdifferent.ecologics.registry.ModBlocks;

@Mod.EventBusSubscriber(modid="ecologics", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class EcologicsForgeClient {
    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        EcologicsClient.init();
        event.enqueueWork(() -> EcologicsClient.addWoodTypes());
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.getBlockColors().m_92589_((pState, pLevel, pPos, pTintIndex) -> pLevel != null && pPos != null ? BiomeColors.m_108804_((BlockAndTintGetter)pLevel, (BlockPos)pPos) : FoliageColor.m_46113_(), new Block[]{(Block)ModBlocks.COCONUT_LEAVES.get()});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.getItemColors().m_92689_((pStack, pTintIndex) -> {
            BlockState blockstate = ((BlockItem)pStack.m_41720_()).m_40614_().m_49966_();
            return event.getBlockColors().m_92577_(blockstate, null, null, pTintIndex);
        }, new ItemLike[]{(ItemLike)ModBlocks.COCONUT_LEAVES.get()});
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(CamelModel.LAYER_LOCATION, CamelModel::createBodyLayer);
        event.registerLayerDefinition(CoconutCrabModel.LAYER_LOCATION, CoconutCrabModel::createBodyLayer);
        event.registerLayerDefinition(SquirrelModel.LAYER_LOCATION, SquirrelModel::createBodyLayer);
        event.registerLayerDefinition(PenguinModel.LAYER_LOCATION, PenguinModel::createBodyLayer);
        for (ModBoat.Type type : ModBoat.Type.values()) {
            event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("ecologics", type.getModelLocation()), "main"), BoatModel::m_246613_);
            event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("ecologics", type.getChestModelLocation()), "main"), ChestBoatModel::m_247175_);
        }
        BlockEntityRenderers.m_173590_(ModBlockEntityTypes.HANGING_SIGN.get(), HangingSignRenderer::new);
    }
}

