/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfight.config;

import com.dragonfight.DragonfightMod;
import com.dragonfight.config.CommonConfiguration;
import com.dragonfight.fight.DragonFightManagerCustom;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigurationCache {
    public static void onConfigChanged() {
        DragonFightManagerCustom.spawnOnCrystalDeath = ConfigurationCache.parseEntityTypes(((CommonConfiguration)DragonfightMod.config.getCommonConfig()).spawnoncrystaldestroy);
        DragonFightManagerCustom.spawnOnCrystalRespawn = ConfigurationCache.parseEntityTypes(((CommonConfiguration)DragonfightMod.config.getCommonConfig()).spawnoncrystalrespawn);
        DragonFightManagerCustom.spawnOnDragonSitting = ConfigurationCache.parseEntityTypes(((CommonConfiguration)DragonfightMod.config.getCommonConfig()).spawnwhilelanded);
    }

    private static ImmutableList<EntityType> parseEntityTypes(List<String> data) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String entry : data) {
            String[] splitEntry;
            for (String entityString : splitEntry = entry.split(",")) {
                ResourceLocation id = ResourceLocation.m_135820_((String)entityString);
                if (id == null) {
                    DragonfightMod.LOGGER.error("Config entry could not be parsed, not a valid resource location " + entityString);
                    continue;
                }
                EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id);
                if (type.equals(ForgeRegistries.ENTITY_TYPES.getValue(ForgeRegistries.ENTITY_TYPES.getDefaultKey()))) {
                    DragonfightMod.LOGGER.error("Config entry could not be parsed, not a valid entity type" + entityString);
                    continue;
                }
                builder.add((Object)type);
            }
        }
        return builder.build();
    }
}

