/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.misc;

import com.github.alexthe668.domesticationinnovation.DomesticationMod;
import com.github.alexthe668.domesticationinnovation.server.enchantment.DIEnchantmentRegistry;
import com.github.alexthe668.domesticationinnovation.server.item.DIItemRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class DILootModifier
extends LootModifier {
    public static final Supplier<Codec<DILootModifier>> CODEC = () -> RecordCodecBuilder.create(inst -> inst.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(lm -> lm.conditions), (App)Codec.INT.fieldOf("loot_type").orElse((Object)0).forGetter(configuration -> configuration.lootType)).apply((Applicative)inst, DILootModifier::new));
    private final int lootType;

    protected DILootModifier(LootItemCondition[] conditionsIn, int lootType) {
        super(conditionsIn);
        this.lootType = lootType;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        switch (this.lootType) {
            case 0: {
                if (!((double)context.m_230907_().m_188501_() < (Double)DomesticationMod.CONFIG.sinisterCarrotLootChance.get())) break;
                generatedLoot.add((Object)new ItemStack((ItemLike)DIItemRegistry.SINISTER_CARROT.get(), context.m_230907_().m_216339_(1, 2)));
                break;
            }
            case 1: {
                if (!((double)context.m_230907_().m_188501_() < (Double)DomesticationMod.CONFIG.bubblingLootChance.get())) break;
                generatedLoot.add((Object)this.enchantedBook(DIEnchantmentRegistry.BUBBLING, context.m_230907_()));
                break;
            }
            case 2: {
                if (!((double)context.m_230907_().m_188501_() < (Double)DomesticationMod.CONFIG.vampirismLootChance.get())) break;
                generatedLoot.add((Object)this.enchantedBook(DIEnchantmentRegistry.VAMPIRE, context.m_230907_()));
                break;
            }
            case 3: {
                if (!((double)context.m_230907_().m_188501_() < (Double)DomesticationMod.CONFIG.voidCloudLootChance.get())) break;
                generatedLoot.add((Object)this.enchantedBook(DIEnchantmentRegistry.VOID_CLOUD, context.m_230907_()));
                break;
            }
            case 4: {
                if (!((double)context.m_230907_().m_188501_() < (Double)DomesticationMod.CONFIG.oreScentingLootChance.get())) break;
                generatedLoot.add((Object)this.enchantedBook(DIEnchantmentRegistry.ORE_SCENTING, context.m_230907_()));
                break;
            }
            case 5: {
                if (!((double)context.m_230907_().m_188501_() < (Double)DomesticationMod.CONFIG.muffledLootChance.get())) break;
                generatedLoot.add((Object)this.enchantedBook(DIEnchantmentRegistry.MUFFLED, context.m_230907_()));
                break;
            }
            case 6: {
                if (!((double)context.m_230907_().m_188501_() < (Double)DomesticationMod.CONFIG.blazingProtectionLootChance.get())) break;
                generatedLoot.add((Object)this.enchantedBook(DIEnchantmentRegistry.BLAZING_PROTECTION, context.m_230907_()));
            }
        }
        return generatedLoot;
    }

    private ItemStack enchantedBook(Enchantment enchantment, RandomSource randomSource) {
        ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
        int maxLevels = enchantment.m_6586_();
        EnchantedBookItem.m_41153_((ItemStack)book, (EnchantmentInstance)new EnchantmentInstance(enchantment, maxLevels > 1 ? 1 + randomSource.m_188503_(maxLevels - 1) : 1));
        return book;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

