/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.mixin;

import com.github.alexthe666.citadel.server.entity.IComandableMob;
import com.github.alexthe668.domesticationinnovation.DomesticationMod;
import com.github.alexthe668.domesticationinnovation.server.entity.ModifedToBeTameable;
import com.github.alexthe668.domesticationinnovation.server.entity.ai.FollowOwner2Goal;
import com.github.alexthe668.domesticationinnovation.server.entity.ai.OwnerHurtTarget2Goal;
import com.github.alexthe668.domesticationinnovation.server.entity.ai.Sit2Goal;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Fox.class})
public abstract class FoxMixin
extends Animal
implements ModifedToBeTameable,
IComandableMob {
    @Shadow
    @Final
    private static EntityDataAccessor<Optional<UUID>> f_28439_;
    @Shadow
    @Final
    private static EntityDataAccessor<Optional<UUID>> f_28440_;
    private static final EntityDataAccessor<Integer> COMMAND;

    @Shadow
    abstract void m_28515_(UUID var1);

    @Shadow
    public abstract void m_28610_(boolean var1);

    @Shadow
    abstract void m_28626_(boolean var1);

    protected FoxMixin(EntityType<? extends Animal> foxType, Level level) {
        super(foxType, level);
    }

    @Inject(at={@At(value="HEAD")}, remap=true, method={"Lnet/minecraft/world/entity/animal/Fox;registerGoals()V"})
    private void di_registerGoals(CallbackInfo ci) {
        this.f_21345_.m_25352_(1, (Goal)new Sit2Goal(this));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwner2Goal(this, 1.0, 10.0f, 3.0f, false));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtTarget2Goal(this));
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/Fox;defineSynchedData()V"})
    private void di_registerData(CallbackInfo ci) {
        this.f_19804_.m_135372_(COMMAND, (Object)0);
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/Fox;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void di_writeAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        compoundNBT.m_128405_("DICommand", this.getCommand());
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/Fox;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void di_readAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        this.setCommand(compoundNBT.m_128451_("DICommand"));
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int i) {
        this.f_19804_.m_135381_(COMMAND, (Object)i);
    }

    @Override
    public boolean isTame() {
        return (((Optional)this.f_19804_.m_135370_(f_28439_)).isPresent() || ((Optional)this.f_19804_.m_135370_(f_28440_)).isPresent()) && (Boolean)DomesticationMod.CONFIG.tameableFox.get() != false;
    }

    @Override
    public void setTame(boolean value) {
    }

    @Inject(at={@At(shift=At.Shift.BEFORE, value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;finishUsingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;")}, remap=true, method={"Lnet/minecraft/world/entity/animal/Fox;aiStep()V"})
    private void di_aiStep(CallbackInfo ci) {
        ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!stack.m_41619_() && stack.m_41720_().m_41472_() && stack.m_41720_().m_41473_() != null) {
            this.m_5634_(stack.m_41720_().m_41473_().m_38744_() * 2);
        }
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"Lnet/minecraft/world/entity/animal/Fox;aiStep()V"})
    private void di_aiStep_2(CallbackInfo ci) {
        if (this.isFollowingOwner()) {
            this.m_28626_(false);
            this.m_28610_(false);
        }
    }

    @Override
    @Nullable
    public UUID getTameOwnerUUID() {
        if (((Optional)this.f_19804_.m_135370_(f_28439_)).isPresent()) {
            return (UUID)((Optional)this.f_19804_.m_135370_(f_28439_)).get();
        }
        return ((Optional)this.f_19804_.m_135370_(f_28440_)).orElse(null);
    }

    @Override
    public void setTameOwnerUUID(@Nullable UUID uuid) {
        this.m_28515_(uuid);
    }

    @Override
    @Nullable
    public LivingEntity getTameOwner() {
        try {
            UUID uuid = this.getTameOwnerUUID();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Override
    public boolean isFollowingOwner() {
        return this.getCommand() == 2 && (Boolean)DomesticationMod.CONFIG.trinaryCommandSystem.get() != false;
    }

    @Override
    public boolean isStayingStill() {
        return this.getCommand() == 1 && (Boolean)DomesticationMod.CONFIG.trinaryCommandSystem.get() != false;
    }

    @Override
    public boolean isValidAttackTarget(LivingEntity target) {
        return true;
    }

    public void sendCommandMessage(Player owner, int command, Component name) {
        owner.m_5661_((Component)Component.m_237110_((String)("message.domesticationinnovation.command_" + command), (Object[])new Object[]{name}), true);
    }

    static {
        COMMAND = SynchedEntityData.m_135353_(Fox.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }
}

