/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.client.screen;

import com.google.common.collect.Lists;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.api.type.IDietSuite;
import com.illusivesoulworks.diet.api.util.DietColor;
import com.illusivesoulworks.diet.client.DietKeys;
import com.illusivesoulworks.diet.client.screen.DietTooltip;
import com.illusivesoulworks.diet.common.config.DietConfig;
import com.illusivesoulworks.diet.common.data.effect.DietEffectsInfo;
import com.illusivesoulworks.diet.common.data.suite.DietSuites;
import com.illusivesoulworks.diet.platform.Services;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class DietScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("minecraft", "textures/gui/demo_background.png");
    private static final ResourceLocation ICONS = new ResourceLocation("diet", "textures/gui/icons.png");
    public static DietEffectsInfo tooltip = new DietEffectsInfo();
    private final Set<IDietGroup> groups = new HashSet<IDietGroup>();
    private final int xSize;
    private int ySize;
    private final boolean fromInventory;

    public DietScreen(boolean fromInventory) {
        super((Component)Component.m_237115_((String)"gui.diet.title"));
        this.xSize = 248;
        this.fromInventory = fromInventory;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && this.f_96541_.f_91073_ != null) {
            this.groups.addAll(Services.CAPABILITY.get((Player)this.f_96541_.f_91074_).map(tracker -> DietSuites.getSuite((Level)this.f_96541_.f_91073_, tracker.getSuite()).map(IDietSuite::getGroups).orElse(Set.of())).orElse(Set.of()));
        }
        this.ySize = this.groups.size() * 20 + 60;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.diet.close"), button -> {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                if (this.fromInventory) {
                    this.f_96541_.m_91152_((Screen)new InventoryScreen((Player)this.f_96541_.f_91074_));
                } else {
                    this.m_7379_();
                }
            }
        }).m_253046_(100, 20).m_252794_(this.f_96543_ / 2 - 50, (this.f_96544_ + this.ySize) / 2 - 30).m_253136_());
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.renderForeground(guiGraphics, mouseX, mouseY);
        this.renderTitle(guiGraphics, mouseX, mouseY);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderTitle(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int titleWidth = this.f_96547_.m_92895_(this.f_96539_.getString());
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_96543_ / 2 - titleWidth / 2, this.f_96544_ / 2 - this.ySize / 2 + 10, this.getTextColor(), false);
        List<DietEffectsInfo.AttributeModifier> modifiers = tooltip.getModifiers();
        List<DietEffectsInfo.StatusEffect> effects = tooltip.getEffects();
        if (!(this.f_96541_ == null || modifiers.isEmpty() && effects.isEmpty())) {
            int lowerX = this.f_96543_ / 2 + titleWidth / 2 + 5;
            int lowerY = this.f_96544_ / 2 - this.ySize / 2 + 7;
            int upperX = lowerX + 16;
            int upperY = lowerY + 16;
            guiGraphics.m_280411_(ICONS, lowerX, lowerY, 16, 16, 0.0f, 37.0f, 16, 16, 256, 256);
            if (mouseX >= lowerX && mouseX <= upperX && mouseY >= lowerY && mouseY <= upperY) {
                List<Component> tooltips = DietTooltip.getEffects();
                guiGraphics.m_280666_(this.f_96547_, tooltips, mouseX, mouseY);
            }
        }
    }

    private int getTextColor() {
        String config = (String)DietConfig.CLIENT.textColor.get();
        if (config.startsWith("#")) {
            return Integer.parseInt(config.substring(1), 16);
        }
        return Integer.parseInt(config);
    }

    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        LocalPlayer player;
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null && (player = this.f_96541_.f_91074_) != null) {
            Services.CAPABILITY.get((Player)player).ifPresent(diet -> DietSuites.getSuite((Level)this.f_96541_.f_91073_, diet.getSuite()).ifPresent(suite -> {
                int y = this.f_96544_ / 2 - this.ySize / 2 + 25;
                int x = this.f_96543_ / 2 - this.xSize / 2 + 10;
                MutableComponent tooltip = null;
                for (IDietGroup group : suite.getGroups()) {
                    guiGraphics.m_280480_(new ItemStack((ItemLike)group.getIcon()), x, y - 5);
                    MutableComponent text = Component.m_237115_((String)("groups.diet." + group.getName() + ".name"));
                    guiGraphics.m_280614_(this.f_96547_, (Component)text, x + 20, y, this.getTextColor(), false);
                    RenderSystem.setShader(GameRenderer::m_172814_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICONS);
                    DietColor color = diet.isActive() ? group.getColor() : DietColor.GRAY;
                    int red = color.red();
                    int green = color.green();
                    int blue = color.blue();
                    int percent = (int)Math.floor(diet.getValue(group.getName()) * 100.0f);
                    String percentText = percent + "%";
                    DietScreen.coloredBlit(guiGraphics.m_280168_(), x + 90, y + 2, 102, 5, 20.0f, 0.0f, 102, 5, 256, 256, red, green, blue, 255);
                    if (percent > 0) {
                        int texWidth = percent + 1;
                        DietScreen.coloredBlit(guiGraphics.m_280168_(), x + 90, y + 2, texWidth, 5, 20.0f, 5.0f, texWidth, 5, 256, 256, red, green, blue, 255);
                    }
                    int xPos = x + 200;
                    int yPos = y + 1;
                    guiGraphics.m_280056_(this.f_96547_, percentText, xPos + 1, yPos, 0, false);
                    guiGraphics.m_280056_(this.f_96547_, percentText, xPos - 1, yPos, 0, false);
                    guiGraphics.m_280056_(this.f_96547_, percentText, xPos, yPos + 1, 0, false);
                    guiGraphics.m_280056_(this.f_96547_, percentText, xPos, yPos - 1, 0, false);
                    guiGraphics.m_280056_(this.f_96547_, percentText, xPos, yPos, color.getRGB(), false);
                    int lowerY = y - 5;
                    int upperX = x + 16;
                    int upperY = lowerY + 16;
                    if (mouseX >= x && mouseX <= upperX && mouseY >= lowerY && mouseY <= upperY) {
                        String key = "groups.diet." + group.getName() + ".tooltip";
                        if (Language.m_128107_().m_6722_(key)) {
                            tooltip = Component.m_237115_((String)key);
                        }
                    }
                    y += 20;
                }
                if (tooltip != null) {
                    ArrayList tooltips = Lists.newArrayList((Object[])new Component[]{tooltip});
                    guiGraphics.m_280666_(this.f_96547_, (List)tooltips, mouseX, mouseY);
                }
            }));
        }
    }

    public void m_280273_(@Nonnull GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
        if (this.f_96541_ != null) {
            int i = (this.f_96543_ - this.xSize) / 2;
            int j = (this.f_96544_ - this.ySize) / 2;
            guiGraphics.m_280411_(BACKGROUND, i, j, this.xSize, 4, 0.0f, 0.0f, 248, 4, 256, 256);
            guiGraphics.m_280411_(BACKGROUND, i, j + 4, this.xSize, this.ySize - 8, 0.0f, 4.0f, 248, 24, 256, 256);
            guiGraphics.m_280411_(BACKGROUND, i, j + this.ySize - 4, this.xSize, 4, 0.0f, 162.0f, 248, 4, 256, 256);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
                this.f_96541_.m_91152_((Screen)new InventoryScreen((Player)this.f_96541_.f_91074_));
                return true;
            }
            if (DietKeys.OPEN_GUI.m_90832_(keyCode, scanCode)) {
                if (this.fromInventory) {
                    this.f_96541_.m_91152_((Screen)new InventoryScreen((Player)this.f_96541_.f_91074_));
                } else {
                    this.m_7379_();
                }
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    private static void coloredBlit(PoseStack matrixStack, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, int red, int green, int blue, int alpha) {
        int x2 = x + width;
        int y2 = y + height;
        float minU = (uOffset + 0.0f) / (float)textureWidth;
        float maxU = (uOffset + (float)uWidth) / (float)textureWidth;
        float minV = (vOffset + 0.0f) / (float)textureHeight;
        float maxV = (vOffset + (float)vHeight) / (float)textureHeight;
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_252986_(matrix, (float)x, (float)y2, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x2, (float)y2, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x2, (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(maxU, minV).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x, (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(minU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }
}

