/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.client.gui;

import com.glisco.deathlog.client.DeathInfo;
import com.glisco.deathlog.client.gui.DeathListEntryContainer;
import com.glisco.deathlog.network.RemoteDeathLogStorage;
import com.glisco.deathlog.storage.DirectDeathLogStorage;
import io.wispforest.owo.config.ui.ConfigScreen;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.DropdownComponent;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.util.Observable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_7923;

public class DeathLogScreen
extends BaseUIModelScreen<FlowLayout> {
    private final class_437 parent;
    private final DirectDeathLogStorage storage;
    private FlowLayout detailPanel;
    private final Observable<String> currentSearchTerm = Observable.of((Object)"");
    private boolean canRestore = true;

    public DeathLogScreen(class_437 parent, DirectDeathLogStorage storage) {
        super(FlowLayout.class, BaseUIModelScreen.DataSource.asset((class_2960)new class_2960("deathlog", "deathlog")));
        this.parent = parent;
        this.storage = storage;
        this.currentSearchTerm.observe(s -> this.buildDeathList());
    }

    protected void method_25426() {
        super.method_25426();
        ButtonComponent configButton = (ButtonComponent)((FlowLayout)this.uiAdapter.rootComponent).childById(ButtonComponent.class, "config-button");
        if (configButton != null) {
            if (this.field_22790 >= 275) {
                configButton.positioning(Positioning.relative((int)100, (int)100)).margins(Insets.none());
            } else {
                configButton.positioning(Positioning.relative((int)100, (int)0)).margins(Insets.top((int)-5));
            }
        }
    }

    protected void build(FlowLayout rootComponent) {
        this.detailPanel = (FlowLayout)rootComponent.childById(FlowLayout.class, "detail-panel");
        ((TextBoxComponent)rootComponent.childById(TextBoxComponent.class, "search-box")).configure(searchBox -> {
            searchBox.onChanged().subscribe(value -> this.currentSearchTerm.set((Object)value.toLowerCase(Locale.ROOT)));
            searchBox.text(this.storage.getDefaultFilter());
        });
        ((ButtonComponent)rootComponent.childById(ButtonComponent.class, "config-button")).onPress(button -> this.field_22787.method_1507((class_437)ConfigScreen.getProvider((String)"deathlog").apply(this)));
        ((LabelComponent)((FlowLayout)this.uiAdapter.rootComponent).childById(LabelComponent.class, "death-count-label")).text((class_2561)class_2561.method_43469((String)"text.deathlog.death_list_title", (Object[])new Object[]{this.storage.getDeathInfoList().size()}));
    }

    public void updateInfo(DeathInfo info, int index) {
        this.storage.getDeathInfoList().set(index, info);
        this.selectInfo(this.storage.getDeathInfoList().get(index));
    }

    public void disableRestoring() {
        this.canRestore = false;
    }

    private void buildDeathList() {
        ((FlowLayout)((FlowLayout)this.uiAdapter.rootComponent).childById(FlowLayout.class, "death-list")).configure(deathList -> {
            deathList.clearChildren();
            for (int i = 0; i < this.storage.getDeathInfoList().size(); ++i) {
                int infoIndex = i;
                DeathInfo deathInfo = this.storage.getDeathInfoList().get(infoIndex);
                if (!((String)this.currentSearchTerm.get()).isBlank() && !deathInfo.createSearchString().contains((CharSequence)this.currentSearchTerm.get())) continue;
                deathList.child(((DeathListEntryContainer)this.model.expandTemplate(DeathListEntryContainer.class, "death-list-entry", Map.of("death-time", deathInfo.getListName().getString(), "death-message", deathInfo.getTitle().getString()))).configure(container -> {
                    container.onSelected().subscribe(c -> this.selectInfo(this.storage.getDeathInfoList().get(infoIndex)));
                    container.mouseDown().subscribe((mouseX, mouseY, button) -> {
                        if (button != 1) {
                            return false;
                        }
                        FlowLayout root = (FlowLayout)this.uiAdapter.rootComponent;
                        DropdownComponent.openContextMenu((class_437)this, (ParentComponent)root, FlowLayout::child, (double)((double)(container.x() - ((Insets)root.padding().get()).left()) + mouseX), (double)((double)(container.y() - ((Insets)root.padding().get()).top()) + mouseY), dropdown -> {
                            dropdown.surface(Surface.flat((int)-1157627904).and(Surface.outline((int)-1486921889)));
                            if (this.canRestore) {
                                dropdown.button((class_2561)class_2561.method_43471((String)"text.deathlog.action.restore"), dropdown_ -> {
                                    this.storage.restore(infoIndex);
                                    dropdown.remove();
                                });
                            }
                            dropdown.button((class_2561)class_2561.method_43471((String)"text.deathlog.action.delete"), dropdown_ -> {
                                this.storage.delete(deathInfo);
                                this.buildDeathList();
                                dropdown.remove();
                            });
                        });
                        return true;
                    });
                }));
            }
        });
    }

    private void selectInfo(DeathInfo info) {
        DirectDeathLogStorage directDeathLogStorage = this.storage;
        if (directDeathLogStorage instanceof RemoteDeathLogStorage) {
            RemoteDeathLogStorage remoteStorage = (RemoteDeathLogStorage)directDeathLogStorage;
            remoteStorage.fetchCompleteInfo(info);
        }
        this.detailPanel.configure(panel -> {
            int i;
            panel.clearChildren();
            if (info.isPartial()) {
                panel.child((Component)Components.label((class_2561)class_2561.method_43471((String)"text.deathlog.death_info_loading")).margins(Insets.top((int)15)));
                return;
            }
            panel.child((Component)Components.label((class_2561)info.getTitle()).shadow(true).margins(Insets.of((int)15, (int)10, (int)0, (int)0)));
            FlowLayout leftColumn = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            FlowLayout rightColumn = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            panel.child((Component)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)leftColumn).child((Component)rightColumn));
            leftColumn.gap(2);
            for (class_2561 text : info.getLeftColumnText()) {
                leftColumn.child((Component)Components.label((class_2561)text).shadow(true));
            }
            rightColumn.gap(2).margins(Insets.left((int)5));
            for (class_2561 text : info.getRightColumnText()) {
                rightColumn.child((Component)Components.label((class_2561)text));
            }
            FlowLayout itemContainer = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            panel.child((Component)itemContainer);
            itemContainer.margins(Insets.top((int)5));
            itemContainer.child((Component)Components.texture((class_2960)new class_2960("deathlog", "textures/gui/inventory_overlay.png"), (int)0, (int)0, (int)210, (int)107));
            FlowLayout armorFlow = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            itemContainer.child((Component)armorFlow);
            armorFlow.positioning(Positioning.absolute((int)185, (int)28));
            for (int i2 = 0; i2 < info.getPlayerArmor().size(); ++i2) {
                armorFlow.child(0, (Component)this.makeItem((class_1799)info.getPlayerArmor().get(i2), Insets.of((int)1)));
            }
            GridLayout itemGrid = Containers.grid((Sizing)Sizing.content(), (Sizing)Sizing.content(), (int)4, (int)9);
            itemContainer.child((Component)itemGrid);
            class_2371<class_1799> inventory = info.getPlayerItems();
            itemGrid.positioning(Positioning.absolute((int)7, (int)24));
            for (i = 0; i < 9; ++i) {
                itemGrid.child((Component)this.makeItem((class_1799)inventory.get(i), Insets.of((int)5, (int)1, (int)1, (int)1)), 3, i);
            }
            for (i = 0; i < 27; ++i) {
                itemGrid.child((Component)this.makeItem((class_1799)inventory.get(9 + i), Insets.of((int)1)), i / 9, i % 9);
            }
            if (!((class_1799)inventory.get(36)).method_7960()) {
                itemContainer.child((Component)this.makeItem((class_1799)inventory.get(36), Insets.none()).positioning(Positioning.absolute((int)186, (int)8)));
            }
        });
    }

    private ItemComponent makeItem(class_1799 stack, Insets margins) {
        ItemComponent item = Components.item((class_1799)stack).showOverlay(true);
        item.margins(margins);
        if (!stack.method_7960()) {
            List tooltip = stack.method_7950((class_1657)this.field_22787.field_1724, (class_1836)(this.field_22787.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
            tooltip.add(class_2561.method_43471((String)(this.field_22787.field_1724.method_7337() ? "text.deathlog.action.give_item.spawn" : "text.deathlog.action.give_item.copy_give")));
            item.tooltip((Collection)tooltip);
            item.mouseDown().subscribe((mouseX, mouseY, button) -> {
                if (button != 2) {
                    return false;
                }
                if (this.field_22787.field_1724.method_7337()) {
                    this.field_22787.field_1761.method_2915(stack);
                } else {
                    String command = "/give " + this.field_22787.field_1724.method_5477().getString() + " " + class_7923.field_41178.method_10221((Object)stack.method_7909()) + stack.method_7948().toString();
                    this.field_22787.field_1774.method_1455(command);
                }
                return true;
            });
        }
        return item;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    static {
        UIParsing.registerFactory((String)"death-list-entry-container", element -> new DeathListEntryContainer());
    }
}

