/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.client;

import com.glisco.deathlog.DeathLogCommon;
import com.glisco.deathlog.client.ClientDeathLogStorage;
import com.glisco.deathlog.client.DeathLogConfig;
import com.glisco.deathlog.client.gui.DeathLogScreen;
import com.glisco.deathlog.network.DeathLogPackets;
import com.glisco.deathlog.storage.BaseDeathLogStorage;
import com.glisco.deathlog.storage.DirectDeathLogStorage;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_447;

@Environment(value=EnvType.CLIENT)
public class DeathLogClient
implements ClientModInitializer {
    public static final DeathLogConfig CONFIG;
    public static final class_304 OPEN_DEATH_SCREEN;
    private static ClientDeathLogStorage storage;

    public void onInitializeClient() {
        storage = new ClientDeathLogStorage();
        DeathLogCommon.setStorage(storage);
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (!(screen instanceof class_447)) {
                return;
            }
            Screens.getButtons((class_437)screen).add(class_4185.method_46430((class_2561)class_2561.method_30163((String)"DeathLog"), button -> this.openScreen(DeathLogClient.getClientStorage())).method_46437(60, 20).method_46433(10, 5).method_46431());
        });
        KeyBindingHelper.registerKeyBinding((class_304)OPEN_DEATH_SCREEN);
        ClientTickEvents.END_CLIENT_TICK.register(minecraftClient -> {
            if (OPEN_DEATH_SCREEN.method_1436()) {
                this.openScreen(DeathLogClient.getClientStorage());
            }
        });
        DeathLogPackets.Client.registerListeners();
    }

    private void openScreen(DirectDeathLogStorage clientStorage) {
        DeathLogClient.openScreen(clientStorage, class_310.method_1551().method_1558() == null);
    }

    public static void openScreen(DirectDeathLogStorage storage, boolean canRestore) {
        DeathLogScreen screen = new DeathLogScreen(class_310.method_1551().field_1755, storage);
        class_310.method_1551().method_1507((class_437)screen);
        if (!canRestore) {
            screen.disableRestoring();
        }
    }

    public static DirectDeathLogStorage getClientStorage() {
        return storage;
    }

    static {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        if (Files.exists(configDir.resolve("deathlog.json"), new LinkOption[0]) && !Files.exists(configDir.resolve("deathlog.json5"), new LinkOption[0])) {
            if (configDir.resolve("deathlog.json").toFile().renameTo(configDir.resolve("deathlog.json5").toFile())) {
                BaseDeathLogStorage.LOGGER.info("Migrated old '.json' config to '.json5'");
            } else {
                BaseDeathLogStorage.LOGGER.warn("Could not migrate old config file");
            }
        }
        CONFIG = DeathLogConfig.createAndLoad();
        OPEN_DEATH_SCREEN = new class_304("key.deathlog.death_screen", 269, "key.categories.misc");
    }
}

