/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import tech.thatgravyboat.creeperoverhaul.api.CreeperPlugin;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;

public final class PluginRegistry {
    private static final PluginRegistry INSTANCE = new PluginRegistry();
    private final Map<ResourceLocation, CreeperPlugin> registeredPlugins = new HashMap<ResourceLocation, CreeperPlugin>();
    private Collection<CreeperPlugin> plugins = this.registeredPlugins.values();

    private PluginRegistry() {
    }

    public static PluginRegistry getInstance() {
        return INSTANCE;
    }

    public void registerPlugins(Collection<CreeperPlugin> plugins) {
        this.registeredPlugins.clear();
        plugins.forEach(this::registerPlugin);
    }

    public void registerPlugin(CreeperPlugin plugin) {
        if (this.registeredPlugins.containsKey(plugin.id())) {
            throw new IllegalArgumentException("Plugin with id " + plugin.id() + " already exists!");
        }
        this.registeredPlugins.put(plugin.id(), plugin);
        this.plugins = this.registeredPlugins.values();
    }

    public CreeperPlugin getPlugin(ResourceLocation id) {
        return this.registeredPlugins.get(id);
    }

    public boolean canAttack(BaseCreeper creeper, LivingEntity entity) {
        for (CreeperPlugin plugin : this.plugins) {
            if (plugin.canAttack(entity)) continue;
            return false;
        }
        return true;
    }

    public boolean isAfraidOf(BaseCreeper creeper, LivingEntity entity) {
        for (CreeperPlugin plugin : this.plugins) {
            if (!plugin.isAfraidOf(creeper, entity)) continue;
            return true;
        }
        return false;
    }
}

