/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.debug;

import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.debug.TrainDebugState;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public record TrainDebugData(UUID sessionId, UUID trainId, String trainName, int totalDuration, int predictionsCount, int predictionsInitialized, TrainDebugState state) {
    private static final String NBT_SESSION_ID = "SessionId";
    private static final String NBT_ID = "Id";
    private static final String NBT_NAME = "Name";
    private static final String NBT_DURATION = "Duration";
    private static final String NBT_PREDICTIONS = "Predictions";
    private static final String NBT_INITIALIZED_PREDICTIONS = "InitializedPredictions";
    private static final String NBT_STATE = "State";

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_(NBT_SESSION_ID, this.sessionId);
        nbt.m_128362_(NBT_ID, this.trainId);
        nbt.m_128359_(NBT_NAME, this.trainName);
        nbt.m_128405_(NBT_DURATION, this.totalDuration);
        nbt.m_128405_(NBT_PREDICTIONS, this.predictionsCount);
        nbt.m_128405_(NBT_INITIALIZED_PREDICTIONS, this.predictionsInitialized);
        nbt.m_128344_(NBT_STATE, this.state.getId());
        return nbt;
    }

    public static TrainDebugData fromNbt(CompoundTag nbt) {
        return new TrainDebugData(nbt.m_128342_(NBT_SESSION_ID), nbt.m_128342_(NBT_ID), nbt.m_128461_(NBT_NAME), nbt.m_128451_(NBT_DURATION), nbt.m_128451_(NBT_PREDICTIONS), nbt.m_128451_(NBT_INITIALIZED_PREDICTIONS), TrainDebugState.getStateById(nbt.m_128445_(NBT_STATE)));
    }

    public static TrainDebugData fromTrain(TrainData train) {
        return new TrainDebugData(train.getSessionId(), train.getTrainId(), train.getTrainName(), train.getTotalDuration(), train.getPredictionsRaw().size(), train.debug_initializedStationsCount(), train.isPreparing() ? TrainDebugState.PREPARING : (train.isInitialized() ? TrainDebugState.READY : TrainDebugState.INITIALIZING));
    }
}

