/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.schedule.instruction;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Pair;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.schedule.instruction.IPredictableInstruction;
import de.mrjulsen.crn.data.schedule.instruction.IStationTagInstruction;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainTravelSection;
import de.mrjulsen.crn.registry.ModBlocks;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TravelSectionInstruction
extends ScheduleInstruction
implements IStationTagInstruction,
IPredictableInstruction {
    public static final String NBT_TRAIN_GROUP = "TrainGroup";
    public static final String NBT_TRAIN_LINE = "TrainLine";
    public static final String NBT_INCLUDE_PREVIOUS_STATION = "IncludePreviousStation";
    public static final String NBT_USABLE = "Usable";

    protected void readAdditional(CompoundTag tag) {
        super.readAdditional(tag);
        if (!tag.m_128441_(NBT_TRAIN_GROUP)) {
            tag.m_128359_(NBT_TRAIN_GROUP, "");
        }
        if (!tag.m_128441_(NBT_TRAIN_LINE)) {
            tag.m_128359_(NBT_TRAIN_LINE, "");
        }
        if (!tag.m_128441_(NBT_INCLUDE_PREVIOUS_STATION)) {
            tag.m_128379_(NBT_INCLUDE_PREVIOUS_STATION, false);
        }
        if (!tag.m_128441_(NBT_USABLE)) {
            tag.m_128379_(NBT_USABLE, true);
        }
    }

    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)new ItemStack((ItemLike)ModBlocks.ADVANCED_DISPLAY.get()), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule.instruction." + this.getId().m_135815_())).m_130940_(ChatFormatting.AQUA));
    }

    public ResourceLocation getId() {
        return new ResourceLocation("createrailwaysnavigator", "travel_section");
    }

    public boolean supportsConditions() {
        return false;
    }

    public List<Component> getTitleAs(String type) {
        String noneText = TextUtils.translate((String)"gui.createrailwaysnavigator.section_settings.none").getString();
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_())).m_130940_(ChatFormatting.GOLD));
        lines.add((Component)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_() + ".description")).m_130940_(ChatFormatting.GRAY));
        if (this.data.m_128441_(NBT_TRAIN_GROUP)) {
            lines.add((Component)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_() + ".train_group")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)TextUtils.text((String)(this.data.m_128461_(NBT_TRAIN_GROUP).isBlank() ? noneText : this.data.m_128461_(NBT_TRAIN_GROUP).toString())).m_130940_(ChatFormatting.WHITE)));
        }
        if (this.data.m_128441_(NBT_TRAIN_LINE)) {
            lines.add((Component)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_() + ".train_line")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)TextUtils.text((String)(this.data.m_128461_(NBT_TRAIN_LINE).isBlank() ? noneText : this.data.m_128461_(NBT_TRAIN_LINE).toString())).m_130940_(ChatFormatting.WHITE)));
        }
        if (this.data.m_128441_(NBT_INCLUDE_PREVIOUS_STATION)) {
            lines.add((Component)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_() + ".include_previous_station")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_(this.data.m_128471_(NBT_INCLUDE_PREVIOUS_STATION) ? CommonComponents.f_130657_ : CommonComponents.f_130658_));
        }
        if (this.data.m_128441_(NBT_USABLE)) {
            lines.add((Component)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_() + ".usable")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_(this.data.m_128471_(NBT_USABLE) ? CommonComponents.f_130657_ : CommonComponents.f_130658_));
        }
        return lines;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        ClientWrapper.initScheduleSectionInstruction(this, builder);
    }

    @Override
    public void run(ScheduleRuntime runtime, TrainData data, Train train, int index) {
        DLUtils.doIfNotNull((Object)data, x -> {
            x.addTravelSection(this.getSectionData((TrainData)x, index));
            x.changeCurrentSection(index);
        });
    }

    private TrainTravelSection getSectionData(TrainData data, int index) {
        return new TrainTravelSection(data, index, GlobalSettings.getInstance().getTrainGroup(this.data.m_128461_(NBT_TRAIN_GROUP)).orElse(null), GlobalSettings.getInstance().getTrainLine(this.data.m_128461_(NBT_TRAIN_LINE)).orElse(null), this.data.m_128471_(NBT_INCLUDE_PREVIOUS_STATION), this.data.m_128471_(NBT_USABLE));
    }

    @Override
    public void predict(TrainData data, ScheduleRuntime runtime, int indexInSchedule, Train train) {
        DLUtils.doIfNotNull((Object)data, x -> x.addTravelSection(this.getSectionData((TrainData)x, indexInSchedule)));
    }
}

