/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Pair;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.ETimeSource;
import de.mrjulsen.crn.data.schedule.IConditionsRequiresInstruction;
import de.mrjulsen.crn.data.schedule.INavigationExtension;
import de.mrjulsen.crn.data.schedule.condition.IDelayedWaitCondition;
import de.mrjulsen.crn.data.train.StationDepartureHistory;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import dev.architectury.utils.GameInstance;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrainSeparationCondition
extends ScheduledDelay
implements IDelayedWaitCondition,
IConditionsRequiresInstruction {
    @Deprecated
    public static final String NBT_TIME = "Value";
    @Deprecated
    public static final String NBT_TIME_UNIT = "TimeUnit";
    public static final String NBT_TICKS = "Ticks";
    public static final String NBT_TRAIN_FILTER = "TrainFilter";
    public static final String NBT_TIME_SOURCE = "TimeSource";

    public TrainSeparationCondition() {
        this.data.m_128344_(NBT_TRAIN_FILTER, StationDepartureHistory.ETrainFilter.ANY.getIndex());
        this.data.m_128405_(NBT_TICKS, 100);
    }

    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)ItemStack.f_41583_, (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule.condition." + this.getId().m_135815_() + ".title"), (Object[])new Object[]{this.formatTime(true)}));
    }

    public ItemStack getSecondLineIcon() {
        return new ItemStack((ItemLike)Items.f_42264_);
    }

    public int totalWaitTicks() {
        return 0;
    }

    private int getDeparationTime() {
        if (this.data.m_128441_(NBT_TICKS)) {
            return this.data.m_128451_(NBT_TICKS);
        }
        return 0;
    }

    protected Component formatTime(boolean compact) {
        int remainingTicks = this.getDeparationTime();
        int minutes = remainingTicks / 1200;
        int seconds = (remainingTicks %= 1200) / 20;
        remainingTicks %= 20;
        if (compact) {
            return TextUtils.text((String)String.format("%d:%02d,%02d", minutes, seconds, remainingTicks));
        }
        return TextUtils.text((String)String.format("%dm %ds %dt", minutes, seconds, remainingTicks));
    }

    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_())), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().m_135815_() + ".description"), (Object[])new Object[]{this.formatTime(false)}).m_130940_(ChatFormatting.DARK_AQUA), (Object)TextUtils.translate((String)this.getTrainFilter().getValueTranslationKey("createrailwaysnavigator")).m_130940_(ChatFormatting.AQUA));
    }

    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        ScheduleEntry entry = (ScheduleEntry)train.runtime.getSchedule().entries.get(train.runtime.currentEntry);
        ((INavigationExtension)train.navigation).addDelayedWaitCondition((de.mrjulsen.mcdragonlib.data.Pair<IDelayedWaitCondition, IDelayedWaitCondition.DelayedWaitConditionContext>)de.mrjulsen.mcdragonlib.data.Pair.of((Object)this, (Object)new IDelayedWaitCondition.DelayedWaitConditionContext(level, train, context, train.getCurrentStation(), entry)));
        return true;
    }

    @Override
    public boolean runDelayed(IDelayedWaitCondition.DelayedWaitConditionContext context) {
        int delayValue = this.getDeparationTime();
        long lastDepartureTimestamp = Long.MIN_VALUE;
        String stationName = "";
        ScheduleEntry entry = context.scheduleEntry();
        ScheduleInstruction scheduleInstruction = entry.instruction;
        if (scheduleInstruction instanceof DestinationInstruction) {
            DestinationInstruction instruction = (DestinationInstruction)scheduleInstruction;
            stationName = instruction.getFilter();
            lastDepartureTimestamp = StationDepartureHistory.getLastMatchingDepartureTime(this.getTrainFilter(), context.train(), stationName);
        }
        if (lastDepartureTimestamp + (long)delayValue < GameInstance.getServer().m_129783_().m_46467_()) {
            StationDepartureHistory.updateDepartureHistory(context.train(), context.station().name);
            return true;
        }
        return false;
    }

    public ResourceLocation getId() {
        return new ResourceLocation("createrailwaysnavigator", "train_separation");
    }

    public StationDepartureHistory.ETrainFilter getTrainFilter() {
        return StationDepartureHistory.ETrainFilter.getByIndex(this.data.m_128445_(NBT_TRAIN_FILTER));
    }

    public ETimeSource getTimeSource() {
        return ETimeSource.getByIndex(this.data.m_128445_(NBT_TIME_SOURCE));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        ClientWrapper.initTimingAdjustmentGui(this, builder);
    }
}

