/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.options;

import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.widgets.options.AbstractDataListEntry;
import de.mrjulsen.crn.client.gui.widgets.options.DataListContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class SimpleDataListEntry<T, S>
extends AbstractDataListEntry<T, S, DisplayableDataSectionDefinition<T, S>> {
    public SimpleDataListEntry(DataListContainer<T, S> parent, int x, int y, int width, S data) {
        super(parent, x, y, width, data);
    }

    public void addDataSection(int width, Function<S, String> displayName, EAlignment alignment, DataListEntryEditContext<T, S> onEdit) {
        this.createSection(new DisplayableDataSectionDefinition<T, S>(this.getCurrentSectionsXOffset(), width, displayName.apply(this.data), alignment, onEdit));
    }

    @Override
    protected void build() {
        for (DisplayableDataSectionDefinition section : this.getSections()) {
            if (section.onEdit == null) continue;
            DisplayableDataSectionDefinition dataSection = section;
            int xCoord = this.x() + this.width() - 0 - 3 - this.getCurrentButtonsXOffset() - section.xOffset - section.width;
            DLEditBox modifyPlatformInput = (DLEditBox)this.addRenderableWidget((GuiEventListener)new DLEditBox(this.font, xCoord + 1, this.y() + 2, section.width - 2, this.height() - 4, (Component)TextUtils.empty()));
            DLButton modifyPlatformBtn = (DLButton)this.addRenderableWidget((GuiEventListener)new DLButton(xCoord, this.y() + 1, section.width, this.height() - 2, (Component)TextUtils.empty(), b -> {
                b.set_visible(false);
                modifyPlatformInput.m_94144_(dataSection.displayName);
                modifyPlatformInput.set_visible(true);
            }));
            modifyPlatformBtn.setRenderStyle(DynamicGuiRenderer.AreaStyle.FLAT);
            modifyPlatformBtn.setBackColor(0);
            modifyPlatformInput.m_94144_("");
            modifyPlatformInput.set_visible(false);
            modifyPlatformInput.withOnFocusChanged((box, focus) -> {
                if (box.visible() && !focus.booleanValue()) {
                    dataSection.onEdit.run(this.parent.getData(), this.data, box.m_94155_(), newData -> newData.ifPresent(a -> this.parent.displayData(a)));
                    modifyPlatformInput.m_94144_("");
                    modifyPlatformInput.set_visible(false);
                    modifyPlatformBtn.set_visible(true);
                }
            });
        }
    }

    @Override
    protected void renderWidgetBase(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    protected void renderSection(Graphics graphics, int mouseX, int mouseY, float partialTicks, DisplayableDataSectionDefinition<T, S> section, GuiAreaDefinition area) {
        CreateDynamicWidgets.renderTextSlotOverlay(graphics, area.getX(), area.getY(), area.getWidth(), area.getHeight());
        switch (section.alignment) {
            case RIGHT: {
                int n = area.getX() + area.getWidth() - 3;
                int n2 = area.getY() + area.getHeight() / 2;
                Objects.requireNonNull(this.font);
                GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)n, (int)(n2 - 9 / 2), (FormattedText)GuiUtils.ellipsisString((Font)this.font, (Component)TextUtils.text((String)section.displayName), (int)(area.getWidth() - 6)), (int)-1, (EAlignment)EAlignment.RIGHT, (boolean)false);
                break;
            }
            case CENTER: {
                int n = area.getX() + 3 + (area.getWidth() - 6) / 2;
                int n3 = area.getY() + area.getHeight() / 2;
                Objects.requireNonNull(this.font);
                GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)n, (int)(n3 - 9 / 2), (FormattedText)GuiUtils.ellipsisString((Font)this.font, (Component)TextUtils.text((String)section.displayName), (int)(area.getWidth() - 6)), (int)-1, (EAlignment)EAlignment.CENTER, (boolean)false);
                break;
            }
            default: {
                int n = area.getX() + 3;
                int n4 = area.getY() + area.getHeight() / 2;
                Objects.requireNonNull(this.font);
                GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)n, (int)(n4 - 9 / 2), (FormattedText)GuiUtils.ellipsisString((Font)this.font, (Component)TextUtils.text((String)section.displayName), (int)(area.getWidth() - 6)), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
            }
        }
    }

    @Override
    protected void renderMainSection(Graphics graphics, int mouseX, int mouseY, float partialTicks, String text, GuiAreaDefinition area) {
        CreateDynamicWidgets.renderTextSlotOverlay(graphics, area.getX(), area.getY(), area.getWidth(), area.getHeight());
        int n = area.getX() + 3;
        int n2 = area.getY() + area.getHeight() / 2;
        Objects.requireNonNull(this.font);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)n, (int)(n2 - 9 / 2), (FormattedText)GuiUtils.ellipsisString((Font)this.font, (Component)TextUtils.text((String)text), (int)(area.getWidth() - 6)), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
    }

    public static class DisplayableDataSectionDefinition<T, S>
    extends AbstractDataListEntry.AbstractDataSectionDefinition<T, S> {
        private final String displayName;
        private final EAlignment alignment;
        private final DataListEntryEditContext<T, S> onEdit;

        public DisplayableDataSectionDefinition(int xOffset, int width, String displayName, EAlignment alignment, DataListEntryEditContext<T, S> onEdit) {
            super(xOffset, width);
            this.displayName = displayName;
            this.alignment = alignment;
            this.onEdit = onEdit;
        }
    }

    @FunctionalInterface
    public static interface DataListEntryEditContext<T, S> {
        public void run(T var1, S var2, String var3, Consumer<Optional<T>> var4);
    }
}

