/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.options;

import com.mojang.blaze3d.systems.RenderSystem;
import de.mrjulsen.crn.client.gui.Animator;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.widgets.options.DLOptionsList;
import de.mrjulsen.crn.client.gui.widgets.options.OptionEntryHeader;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public class OptionEntry<T extends DLWidgetContainer>
extends DLWidgetContainer {
    private int btnX = 0;
    private final Collection<DLButton> additionalButtons = new ArrayList<DLButton>();
    private final Collection<DLTooltip> tooltips = new ArrayList<DLTooltip>();
    private List<FormattedText> descriptionTooltips;
    private final int initialHeight = 20;
    private final Component description;
    private Component text;
    private final Screen parent;
    private final DLOptionsList parentList;
    private final T contentContainer;
    private final Consumer<OptionEntry<T>> onSizeChanged;
    private final OptionEntryHeader header;
    private DLEditBox editBox;
    private final Animator animator = (Animator)this.addRenderableOnly((Renderable)new Animator());
    private boolean expanded;

    public static void expandOrCollapse(OptionEntry<?> entry) {
        if (entry.isExpanded()) {
            entry.collapse();
        } else {
            entry.expand();
        }
    }

    public OptionEntry(Screen parent, DLOptionsList parentList, int x, int y, int width, Function<OptionEntry<T>, T> contentContainer, Component text, Component description, Consumer<OptionEntry<T>> onSizeChanged, BiConsumer<OptionEntry<T>, OptionEntryHeader> onHeaderClick, Function<String, Boolean> onTitleEdited) {
        super(x, y, width, 20);
        this.parent = parent;
        this.parentList = parentList;
        this.text = text;
        this.contentContainer = contentContainer != null ? (DLWidgetContainer)contentContainer.apply(this) : null;
        this.description = description;
        this.onSizeChanged = onSizeChanged;
        this.setTooltip(this.font.m_92865_().m_92414_((FormattedText)description, width, Style.f_131099_));
        this.header = (OptionEntryHeader)this.addRenderableWidget((GuiEventListener)new OptionEntryHeader(this, this.x(), this.y(), this.width(), text, b -> onHeaderClick.accept(this, (OptionEntryHeader)((Object)b))));
        DLUtils.doIfNotNull(this.contentContainer, a -> {
            this.addRenderableWidget((GuiEventListener)a);
            a.set_visible(false);
        });
        if (onTitleEdited != null) {
            int n = this.x() + 5;
            int n2 = this.y() + 6;
            int n3 = this.width() - 5 - 25;
            Objects.requireNonNull(this.font);
            this.editBox = (DLEditBox)this.addRenderableWidget((GuiEventListener)new DLEditBox(this.font, n, n2, n3, 9, text){

                public void setMouseSelected(boolean selected) {
                    super.setMouseSelected(selected);
                    if (selected) {
                        OptionEntry.this.header.setMouseSelected(true);
                    }
                }
            });
            this.editBox.m_94144_(text.getString());
            this.editBox.m_94182_(false);
            this.editBox.m_94199_(32);
            this.editBox.set_visible(false);
            this.editBox.withOnFocusChanged((box, focus) -> {
                if (!focus.booleanValue() && ((Boolean)onTitleEdited.apply(box.m_94155_())).booleanValue()) {
                    this.text = TextUtils.text((String)box.m_94155_());
                    this.header.m_93666_(this.text);
                }
            });
        }
        this.animator.start(4, null, null, null);
    }

    public void addAdditionalButton(Sprite icon, Component text, BiConsumer<OptionEntry<T>, DLIconButton> onClick) {
        DLIconButton btn = new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, icon, this.x() + this.width() - 2 - 18 - this.btnX - 16, this.y() + 2, 16, 16, (Component)TextUtils.empty(), x -> onClick.accept(this, (DLIconButton)x)){

            public void setMouseSelected(boolean selected) {
                super.setMouseSelected(selected);
                if (selected) {
                    OptionEntry.this.header.setMouseSelected(true);
                }
            }
        };
        btn.setBackColor(0);
        DLTooltip tooltip = DLTooltip.of((FormattedText)text).assignedTo((AbstractWidget)btn);
        tooltip.setDynamicOffset(() -> (int)this.parentList.getXScrollOffset(), () -> (int)this.parentList.getYScrollOffset());
        this.tooltips.add(tooltip);
        this.btnX += btn.width();
        this.addRenderableWidget((GuiEventListener)btn);
        this.additionalButtons.add((DLButton)btn);
    }

    public OptionEntry(Screen parent, DLOptionsList parentList, int x, int y, int width, Function<OptionEntry<T>, T> contentContainer, Component text, Component description, Consumer<OptionEntry<T>> onExpandedChanged, BiConsumer<OptionEntry<T>, OptionEntryHeader> onHeaderClick) {
        this(parent, parentList, x, y, width, contentContainer, text, description, onExpandedChanged, onHeaderClick, null);
    }

    public GuiAreaDefinition getContentSpace() {
        return new GuiAreaDefinition(this.x() + 3, this.y() + 20, this.width() - 6, this.height() - 20 - 2);
    }

    public void collapse() {
        this.expanded = false;
        this.set_height(20);
        DLUtils.doIfNotNull((Object)this.editBox, a -> {
            a.m_94194_(false);
            a.m_93674_(this.width() - 5 - 5 - 18 - this.btnX);
        });
        DLUtils.doIfNotNull(this.contentContainer, a -> a.set_visible(false));
        this.onSizeChanged.accept(this);
    }

    public void expand() {
        this.expanded = true;
        DLUtils.doIfNotNull(this.contentContainer, a -> {
            this.set_height(20 + a.height() + 2);
            a.set_visible(true);
        });
        DLUtils.doIfNotNull((Object)this.editBox, a -> a.m_94194_(true));
        this.onSizeChanged.accept(this);
    }

    public void notifyContentSizeChanged() {
        DLUtils.doIfNotNull(this.contentContainer, a -> this.set_height(20 + a.height() + 2));
        this.onSizeChanged.accept(this);
    }

    public int getInitialHeight() {
        return 20;
    }

    public Component getText() {
        return this.text;
    }

    public Component getDescription() {
        return this.description;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public T getContentContainer() {
        return this.contentContainer;
    }

    public void setTooltip(List<FormattedText> tooltip) {
        this.descriptionTooltips = tooltip;
    }

    public List<FormattedText> getTooltips() {
        return this.descriptionTooltips;
    }

    public DLOptionsList getParentList() {
        return this.parentList;
    }

    public Screen getParentScreen() {
        return this.parent;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.poseStack().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        if (this.animator.isRunning()) {
            graphics.poseStack().m_252880_((float)(-this.animator.getTotalTicks() * 5) + this.animator.getCurrentTicksSmooth() * 5.0f, 0.0f, 0.0f);
            GuiUtils.setTint((float)1.0f, (float)1.0f, (float)1.0f, (float)this.animator.getPercentage());
        }
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.x() + 1, this.y(), this.width() - 2, this.height(), CreateDynamicWidgets.ColorShade.LIGHT);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        DLUtils.doIfNotNull((Object)this.editBox, a -> {
            if (a.visible()) {
                CreateDynamicWidgets.renderTextBox(graphics, this.x() + 1, this.y() + 1, this.width() - 2 - 2 - 20 - this.btnX);
                this.editBox.m_88315_(graphics.graphics(), mouseX, mouseY, partialTicks);
            }
        });
        if (this.isExpanded() && this.contentContainer != null) {
            GuiUtils.fillGradient((Graphics)graphics, (int)(this.x() + 3), (int)(this.y() + 20), (int)0, (int)(this.width() - 6), (int)10, (int)0x77000000, (int)0);
        }
        graphics.poseStack().m_85849_();
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
        this.tooltips.stream().forEach(x -> x.render(this.parent, graphics, mouseX, mouseY));
    }
}

