/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.overlay;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.client.ModGuiUtils;
import de.mrjulsen.crn.client.gui.overlay.OverlayPosition;
import de.mrjulsen.crn.client.gui.overlay.pages.AbstractRouteDetailsPage;
import de.mrjulsen.crn.client.gui.overlay.pages.ConnectionMissedPage;
import de.mrjulsen.crn.client.gui.overlay.pages.JourneyCompletedPage;
import de.mrjulsen.crn.client.gui.overlay.pages.NextConnectionsPage;
import de.mrjulsen.crn.client.gui.overlay.pages.RouteOverviewPage;
import de.mrjulsen.crn.client.gui.overlay.pages.TrainCancelledInfo;
import de.mrjulsen.crn.client.gui.overlay.pages.TransferPage;
import de.mrjulsen.crn.client.gui.overlay.pages.WelcomePage;
import de.mrjulsen.crn.client.gui.screen.RouteOverlaySettingsScreen;
import de.mrjulsen.crn.client.input.ModKeys;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.TransferConnection;
import de.mrjulsen.crn.registry.ModItems;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.DLOverlayScreen;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class RouteDetailsOverlay
extends DLOverlayScreen {
    private static final ResourceLocation GUI = new ResourceLocation("createrailwaysnavigator", "textures/gui/overview.png");
    private static final Component title = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.title");
    private static final int GUI_WIDTH = 226;
    private static final int GUI_HEIGHT = 118;
    private static final int SLIDING_TEXT_AREA_WIDTH = 220;
    private final Level level;
    private Component slidingText = TextUtils.empty();
    private float slidingTextOffset = 0.0f;
    private int slidingTextWidth = 0;
    private LerpedFloat xPos;
    private LerpedFloat yPos;
    private static final String keyTrainDetails = "gui.createrailwaysnavigator.route_overview.train_details";
    private static final String keyTransfer = "gui.createrailwaysnavigator.route_overview.transfer";
    private static final String keyTransferWithPlatform = "gui.createrailwaysnavigator.route_overview.transfer_with_platform";
    private static final String keyAfterJourney = "gui.createrailwaysnavigator.route_overview.after_journey";
    private static final String keyOptionsText = "gui.createrailwaysnavigator.route_overview.options";
    private static final String keyKeybindOptions = "key.createrailwaysnavigator.route_overlay_options";
    private static final String keyJourneyBegins = "gui.createrailwaysnavigator.route_overview.journey_begins";
    private static final String keyJourneyBeginsWithPlatform = "gui.createrailwaysnavigator.route_overview.journey_begins_with_platform";
    private static final String keyNextStop = "gui.createrailwaysnavigator.route_overview.next_stop";
    private static final String keyConnectionMissedInfo = "gui.createrailwaysnavigator.route_overview.connection_missed_info";
    private static final String keyTrainCancelledInfo = "gui.createrailwaysnavigator.route_overview.train_cancelled_info";
    private final Font font;
    private final ClientRoute route;
    private boolean journeyCompleted;
    private AbstractRouteDetailsPage currentPage;

    public RouteDetailsOverlay(Level level, ClientRoute route, int width, int height) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.journeyCompleted = false;
        this.level = level;
        this.route = route;
        route.addListener();
        this.currentPage = new WelcomePage(this.route);
        String terminus = route.getStart().getDisplayTitle();
        StationTag.StationInfo info = route.getStart().getRealTimeStationTag().info();
        this.setSlidingText((Component)(info.platform().isEmpty() ? CustomLanguage.translate(keyJourneyBegins, route.getStart().getTrainDisplayName(), terminus, ModUtils.formatTime(route.getStart().getScheduledDepartureTime(), false)) : CustomLanguage.translate(keyJourneyBeginsWithPlatform, route.getStart().getTrainDisplayName(), terminus, ModUtils.formatTime(route.getStart().getScheduledDepartureTime(), false), info.platform())));
        this.xPos = LerpedFloat.linear().startWithValue((double)(width / 2) - (Double)ModClientConfig.OVERLAY_SCALE.get() * 113.0);
        this.yPos = LerpedFloat.linear().startWithValue((double)(height / 2) - (Double)ModClientConfig.OVERLAY_SCALE.get() * 59.0);
        if (route.isClosed()) {
            return;
        }
        route.listen("departure_from_any_stop", (Object)this, x -> {
            this.currentPage = new RouteOverviewPage(this.route);
            String terminus = x.part().getNextStop().getTerminusText();
            this.setSlidingText((Component)CustomLanguage.translate(keyTrainDetails, x.part().getNextStop().getTrainDisplayName(), terminus == null || terminus.isEmpty() ? x.part().getNextStop().getScheduleTitle() : terminus));
        });
        route.listen("first_stop_station_changed", (Object)this, x -> this.setSlidingText((Component)(x.trainStop().getRealTimeStationTag().info().platform().isEmpty() ? CustomLanguage.translate(keyJourneyBegins) : CustomLanguage.translate(keyJourneyBeginsWithPlatform, x.trainStop().getRealTimeStationTag().info().platform()))));
        route.listen("arrival_at_any_stop", (Object)this, x -> this.setSlidingText((Component)TextUtils.text((String)x.trainStop().getClientTag().tagName())));
        route.listen("any_stop_announced", (Object)this, x -> {
            NextConnectionsPage page = new NextConnectionsPage(this.route, null);
            if (page.hasConnections()) {
                this.currentPage = page;
            }
        });
        route.listen("announce_stopover", (Object)this, x -> this.setSlidingText((Component)CustomLanguage.translate(keyNextStop, x.trainStop().getClientTag().tagName())));
        route.listen("announce_last_stop", (Object)this, x -> this.setSlidingText((Component)CustomLanguage.translate(keyNextStop, x.trainStop().getClientTag().tagName())));
        route.listen("announce_transfer_arrival_station", (Object)this, x -> {
            if (x.connection().isConnectionMissed()) {
                this.connectionMissed();
                return;
            }
            this.setSlidingText((Component)CustomLanguage.translate(keyNextStop, x.trainStop().getClientTag().tagName()).m_130946_("   ***   ").m_7220_(this.getTransferSlidingText(x.connection())));
            this.currentPage = new TransferPage(this.route, x.connection());
        });
        route.listen("part_changed", (Object)this, x -> {
            if (x.connection().isConnectionMissed()) {
                this.connectionMissed();
            }
        });
        route.listen("departure_from_transfer_arrival_station", (Object)this, x -> {
            this.setSlidingText((Component)TextUtils.text((String)x.connection().getArrivalStation().getClientTag().tagName()).m_130946_("   ***   ").m_7220_(this.getTransferSlidingText(x.connection())));
            this.currentPage = new TransferPage(this.route, x.connection());
        });
        route.listen("arrival_at_last_stop", (Object)this, x -> {
            this.setSlidingText((Component)CustomLanguage.translate(keyAfterJourney, x.trainStop().getClientTag().tagName()));
            this.currentPage = new JourneyCompletedPage(this.route, () -> {
                this.currentPage = new NextConnectionsPage(route, () -> {});
            });
            route.close();
        });
        route.listen("departure_from_last_stop", (Object)this, x -> {
            if (this.journeyCompleted) {
                return;
            }
            this.setSlidingText((Component)CustomLanguage.translate(keyAfterJourney, x.trainStop().getClientTag().tagName()));
            this.currentPage = new JourneyCompletedPage(this.route, () -> {
                this.currentPage = new NextConnectionsPage(route, () -> {});
            });
            route.close();
        });
        route.listen("any_transfer_missed", (Object)this, x -> this.connectionMissed());
        route.listen("train_cancelled", (Object)this, x -> this.trainCancelled(x.part().getLastStop().getTrainDisplayName()));
    }

    private Component getTransferSlidingText(TransferConnection connection) {
        StationTag.StationInfo info = connection.getDepartureStation().getRealTimeStationTag().info();
        String terminus = connection.getDepartureStation().getDisplayTitle();
        return info == null || info.platform().isBlank() ? CustomLanguage.translate(keyTransfer, connection.getDepartureStation().getTrainDisplayName(), terminus) : CustomLanguage.translate(keyTransferWithPlatform, connection.getDepartureStation().getTrainDisplayName(), terminus, info.platform());
    }

    private void connectionMissed() {
        this.setSlidingText((Component)CustomLanguage.translate(keyConnectionMissedInfo));
        this.currentPage = new ConnectionMissedPage(this.route);
        this.route.close();
    }

    private void trainCancelled(String trainName) {
        this.setSlidingText((Component)CustomLanguage.translate(keyTrainCancelledInfo, trainName));
        this.currentPage = new TrainCancelledInfo(this.route, trainName);
        this.route.close();
    }

    private float getUIScale() {
        return (float)((Double)ModClientConfig.OVERLAY_SCALE.get()).doubleValue();
    }

    public void onClose() {
        this.route.close();
        this.journeyCompleted = true;
    }

    public void m_94120_() {
        if (Screen.m_96637_() && ModKeys.KEY_OVERLAY_SETTINGS.m_90857_() && Minecraft.m_91087_().f_91074_.m_150109_().m_18949_(Set.of((Item)ModItems.NAVIGATOR.get()))) {
            DLScreen.setScreen((DLScreen)new RouteOverlaySettingsScreen(this));
        }
        this.xPos.tickChaser();
        this.yPos.tickChaser();
        DLUtils.doIfNotNull((Object)((Object)this.currentPage), x -> x.m_94120_());
    }

    protected void tickSlidingText(float delta) {
        if ((float)this.slidingTextWidth > 165.0f) {
            this.slidingTextOffset -= delta;
            if (this.slidingTextOffset < (float)(-(this.slidingTextWidth / 2))) {
                this.slidingTextOffset = 220 + this.slidingTextWidth / 2 + 20;
            }
        }
    }

    private void startStencil(Graphics graphics, int x, int y, int w, int h) {
        UIRenderHelper.swapAndBlitColor((RenderTarget)Minecraft.m_91087_().m_91385_(), (RenderTarget)UIRenderHelper.framebuffer);
        ModGuiUtils.startStencil(graphics, x, y, w, h);
    }

    private void endStencil() {
        ModGuiUtils.endStencil();
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)Minecraft.m_91087_().m_91385_());
    }

    private void setSlidingText(Component component) {
        this.slidingText = component;
        this.slidingTextWidth = this.font.m_92852_((FormattedText)component);
        this.slidingTextOffset = (float)this.slidingTextWidth > 165.0f ? (float)(220 + this.slidingTextWidth / 2 + 20) : 82.0f;
    }

    public void render(Graphics graphics, float partialTicks, int width, int height) {
        width = Minecraft.m_91087_().m_91268_().m_85445_();
        height = Minecraft.m_91087_().m_91268_().m_85446_();
        partialTicks = Minecraft.m_91087_().m_91296_();
        OverlayPosition pos = (OverlayPosition)((Object)ModClientConfig.ROUTE_OVERLAY_POSITION.get());
        int x = pos == OverlayPosition.TOP_LEFT || pos == OverlayPosition.BOTTOM_LEFT ? 8 : (int)((float)width - 226.0f * this.getUIScale() - 10.0f);
        int y = pos == OverlayPosition.TOP_LEFT || pos == OverlayPosition.TOP_RIGHT ? 8 : (int)((float)height - 118.0f * this.getUIScale() - 10.0f);
        this.xPos.chase((double)x, (double)0.2f, LerpedFloat.Chaser.EXP);
        this.yPos.chase((double)y, (double)0.2f, LerpedFloat.Chaser.EXP);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_((float)((int)this.xPos.getValue(partialTicks)), (float)((int)this.yPos.getValue(partialTicks)), 0.0f);
        this.renderInternal(graphics, 0, 0, width, height, partialTicks, (int)this.xPos.getValue(partialTicks), (int)this.yPos.getValue(partialTicks));
        graphics.poseStack().m_85849_();
        this.tickSlidingText(2.0f * Minecraft.m_91087_().m_91297_());
    }

    public void renderSlidingText(Graphics graphics, int x, int y, int transX, int transY) {
        this.startStencil(graphics, x + 3, y + 14, 220, 21);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(1.3333334f, 1.3333334f, 1.3333334f);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)((int)((float)(x + 3) + this.slidingTextOffset)), (int)(y + 14), (FormattedText)this.slidingText, (int)0xFF9900, (EAlignment)EAlignment.CENTER, (boolean)false);
        graphics.poseStack().m_85849_();
        this.endStencil();
    }

    private void renderInternal(Graphics graphics, int x, int y, int width, int height, float partialTicks, int transX, int transY) {
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(this.getUIScale(), this.getUIScale(), this.getUIScale());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI);
        GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)x, (int)y, (int)226, (int)118, (int)0, (int)(this.currentPage != null && this.currentPage.isImportant() ? 138 : 0), (int)256, (int)256);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(x + 6), (int)(y + 4), (FormattedText)title, (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        Objects.requireNonNull(this.font);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(x + 6), (int)(y + 118 - 2 - 9), (FormattedText)TextUtils.translate((String)keyOptionsText, (Object[])new Object[]{TextUtils.translate((String)InputConstants.m_84827_((int)(Minecraft.f_91002_ ? 343 : 341), (int)0).m_84874_()).m_130946_(" + ").m_7220_((Component)TextUtils.keybind((String)keyKeybindOptions)).m_130940_(ChatFormatting.BOLD)}), (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        String timeString = TimeUtils.parseTime((long)((int)((this.level.m_46468_() + DragonLib.daytimeShift()) % DragonLib.ticksPerDay())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(x + 226 - 4 - this.font.m_92895_(timeString)), (int)(y + 4), (String)timeString, (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        this.renderSlidingText(graphics, x, y + 2, transX, transY);
        this.startStencil(graphics, x + 3, y + 40, 220, 62);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_(3.0f, 40.0f, 0.0f);
        DLUtils.doIfNotNull((Object)((Object)this.currentPage), a -> {
            a.renderBackLayer(graphics, 0, 0, partialTicks);
            a.renderMainLayer(graphics, 0, 0, partialTicks);
        });
        graphics.poseStack().m_85849_();
        this.endStencil();
        DLUtils.doIfNotNull((Object)((Object)this.currentPage), a -> a.renderFrontLayer(graphics, 0, 0, partialTicks));
        if (CreateRailwaysNavigator.isDebug()) {
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)5, (int)128, (String)("State: " + String.valueOf((Object)this.route.getState()) + ", " + this.route.getCurrentPartIndex() + ", " + this.route.getCurrentPart().getNextStop().getClientTag().tagName()), (int)-65536, (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        graphics.poseStack().m_85849_();
    }

    public ClientRoute getRoute() {
        return this.route;
    }
}

