/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createterminal.menu;

import com.tom.createterminal.behaviour.ContraptionWorld;
import com.tom.createterminal.mixin.CraftingTerminalBlockEntityAccessor;
import com.tom.createterminal.mixin.StorageTerminalBlockEntityAccessor;
import com.tom.storagemod.util.StoredItemStack;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface ITerminal
extends MenuProvider {
    public StoredItemStack pushStack(StoredItemStack var1);

    public void dropItem(ItemStack var1);

    public void updateServer();

    public boolean canInteractWith(Player var1);

    public ContraptionWorld getContraption();

    public static interface ICraftingTerminalImpl
    extends ITerminalImpl {
        @Override
        default public void updateServer() {
            ITerminalImpl.super.updateServer();
            ((CraftingTerminalBlockEntityAccessor)((Object)this)).setCraftingCooldown(0);
        }
    }

    public static interface ITerminalImpl
    extends ITerminal {
        @Override
        default public void dropItem(ItemStack st) {
            this.getContraption().popItem(st);
        }

        @Override
        default public void updateServer() {
            StorageTerminalBlockEntityAccessor ac = (StorageTerminalBlockEntityAccessor)((Object)this);
            if (ac.isUpdateItems()) {
                Map<StoredItemStack, Long> items = ac.getItems();
                items.clear();
                IItemHandlerModifiable itemHandler = this.getContraption().getContraption().getSharedInventory();
                ac.setItemHandler((IItemHandler)itemHandler);
                if (itemHandler != null) {
                    IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(s -> !s.m_41619_()).map(StoredItemStack::new).forEach(s -> items.merge((StoredItemStack)s, s.getQuantity(), (a, b) -> a + b));
                }
                ac.setUpdateItems(false);
            }
        }

        @Override
        default public boolean canInteractWith(Player player) {
            return this.getContraption().isValid() && player.m_20238_(this.getContraption().getActualPosition()) < 64.0;
        }
    }
}

