/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCDamageTypes;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.CannonDamageSource;
import rbasamoyai.createbigcannons.munitions.ImpactExplosion;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.config.DimensionMunitionPropertiesHandler;
import rbasamoyai.createbigcannons.munitions.config.FluidDragHandler;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import rbasamoyai.createbigcannons.munitions.config.components.EntityDamagePropertiesComponent;
import rbasamoyai.createbigcannons.network.ClientboundPlayBlockHitEffectPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;
import rbasamoyai.ritchiesprojectilelib.RitchiesProjectileLib;
import rbasamoyai.ritchiesprojectilelib.network.ClientboundPreciseMotionSyncPacket;

public abstract class AbstractCannonProjectile
extends Projectile {
    protected static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.m_135353_(AbstractCannonProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> PROJECTILE_MASS = SynchedEntityData.m_135353_(AbstractCannonProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected int inGroundTime = 0;
    @Nullable
    protected Vec3 inGroundPos = null;
    protected float damage;
    protected int inFluidTime = 0;
    protected int penetrationTime = 0;
    @Nullable
    protected Vec3 nextVelocity = null;
    @Nullable
    protected Vec3 orientation = null;
    protected BlockState lastPenetratedBlock = Blocks.f_50016_.m_49966_();
    protected boolean removeNextTick = false;
    protected int localSoundCooldown;
    protected WeakHashMap<Entity, Integer> untouchableEntities = new WeakHashMap();

    protected AbstractCannonProjectile(EntityType<? extends AbstractCannonProjectile> type, Level level) {
        super(type, level);
        this.damage = this.getDamageProperties().entityDamage();
        this.setProjectileMass(this.getBallisticProperties().durabilityMass());
    }

    @Nonnull
    public abstract EntityDamagePropertiesComponent getDamageProperties();

    public void m_8119_() {
        if (this.removeNextTick) {
            this.m_146870_();
            return;
        }
        ChunkPos cpos = new ChunkPos(this.m_20183_());
        if (this.m_9236_().f_46443_ || this.m_9236_().m_7232_(cpos.f_45578_, cpos.f_45579_)) {
            Level entry;
            super.m_8119_();
            if (this.nextVelocity != null) {
                boolean stop;
                boolean bl = stop = this.nextVelocity.m_82556_() < 1.0E-4;
                if (!this.m_9236_().f_46443_ || stop) {
                    if (stop) {
                        this.setInGround(true);
                        this.setGroundPos(this.m_20182_());
                    }
                    this.m_20256_(this.nextVelocity);
                }
                this.nextVelocity = null;
            }
            if (!this.isInGround()) {
                this.clipAndDamage();
            }
            this.onTickRotate();
            if (this.isInGround()) {
                this.m_20256_(Vec3.f_82478_);
                if (!this.m_9236_().f_46443_) {
                    if (this.shouldFall()) {
                        this.setInGround(false);
                        this.setGroundPos(null);
                    } else if (!this.canLingerInGround()) {
                        ++this.inGroundTime;
                        if (this.inGroundTime == 400) {
                            this.m_146870_();
                        }
                    }
                }
            } else {
                this.inGroundTime = 0;
                Vec3 oldVel = this.m_20184_();
                Vec3 oldPos = this.m_20182_();
                if (this.nextVelocity != null) {
                    Vec3 newPos = oldPos.m_82549_(oldVel);
                    this.m_146884_(newPos);
                } else {
                    Vec3 accel = this.getForces(oldPos, oldVel);
                    Vec3 newPos = oldPos.m_82549_(oldVel).m_82549_(accel.m_82490_(0.5));
                    this.m_146884_(newPos);
                    this.m_20256_(oldVel.m_82549_(accel));
                }
                this.m_146922_(AbstractCannonProjectile.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
                this.m_146926_(AbstractCannonProjectile.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            }
            Iterator<Map.Entry<Entity, Integer>> iter = this.untouchableEntities.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                if (entry.getKey().m_213877_() || entry.getValue() > 0 && (Integer)entry.getValue() - 1 == 0) {
                    iter.remove();
                    continue;
                }
                if ((Integer)entry.getValue() <= 0) continue;
                entry.setValue((Integer)entry.getValue() - 1);
            }
            if (this.inFluidTime > 0) {
                --this.inFluidTime;
            }
            if (this.penetrationTime > 0) {
                --this.penetrationTime;
            }
            if (this.localSoundCooldown > 0) {
                --this.localSoundCooldown;
            }
            if ((entry = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel slevel = (ServerLevel)entry;
                if (!this.m_213877_() && ((Boolean)CBCConfigs.SERVER.munitions.projectilesCanChunkload.get()).booleanValue()) {
                    ChunkPos cpos1 = new ChunkPos(this.m_20183_());
                    RitchiesProjectileLib.queueForceLoad((ServerLevel)slevel, (int)cpos1.f_45578_, (int)cpos1.f_45579_);
                }
            }
        }
    }

    protected void onTickRotate() {
    }

    protected Vec3 getForces(Vec3 position, Vec3 velocity) {
        return velocity.m_82541_().m_82490_(-this.getDragForce()).m_82520_(0.0, this.getGravity(), 0.0);
    }

    public Vec3 getOrientation() {
        return this.orientation == null ? this.m_20184_() : this.orientation;
    }

    public void setOrientation(Vec3 orientation) {
        this.orientation = orientation;
    }

    public void m_6453_(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean teleport) {
        if (this.f_19797_ < 2) {
            return;
        }
        super.m_6453_(x, y, z, yRot, xRot, lerpSteps, teleport);
    }

    public void setLocalSoundCooldown(int value) {
        this.localSoundCooldown = value;
    }

    public int getLocalSoundCooldown() {
        return this.localSoundCooldown;
    }

    /*
     * WARNING - void declaration
     */
    protected void clipAndDamage() {
        Vec3 pos;
        ProjectileContext projCtx = new ProjectileContext(this, (CBCCfgMunitions.GriefState)((Object)CBCConfigs.SERVER.munitions.damageRestriction.get()));
        Vec3 currentStart = pos = this.m_20182_();
        double reach = (double)Math.max(this.m_20205_(), this.m_20206_()) * 0.5;
        double t = 1.0;
        int MAX_ITER = 100;
        Vec3 originalVel = this.m_20184_();
        Vec3 accel = this.getForces(pos, originalVel);
        Vec3 trajectory = originalVel.m_82549_(accel);
        Vec3 finalEnd = pos.m_82549_(trajectory);
        double velMag = trajectory.m_82553_();
        double vmRecip = 1.0 / velMag;
        boolean shouldRemove = false;
        boolean stop = false;
        for (int p = 0; p < MAX_ITER; ++p) {
            void var20_17;
            void var20_20;
            BlockHitResult fluidResult;
            if (velMag * t < 0.01) {
                this.lastPenetratedBlock = Blocks.f_50016_.m_49966_();
                break;
            }
            Vec3 vec3 = currentStart.m_82549_(trajectory.m_82490_(t));
            BlockHitResult blockHitResult = this.m_9236_().m_45547_(new ClipContext(currentStart, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (blockHitResult.m_6662_() != HitResult.Type.MISS) {
                Vec3 vec32 = blockHitResult.m_82450_();
            }
            if (p == 0 && (fluidResult = this.m_9236_().m_45547_(new ClipContext(currentStart, (Vec3)var20_20, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this))).m_6662_() != HitResult.Type.MISS) {
                BlockPos fluidPos = fluidResult.m_82425_();
                BlockState state = this.m_9236_().m_8055_(fluidPos);
                if (state.m_60734_() instanceof LiquidBlock) {
                    if (this.inFluidTime <= 0 && (stop = this.onImpactFluid(projCtx, state, this.m_9236_().m_6425_(fluidPos), fluidResult.m_82450_(), fluidResult))) {
                        Vec3 vec33 = blockHitResult.m_82450_();
                    }
                    this.inFluidTime = 2;
                }
            }
            if (this.onClip(projCtx, currentStart, (Vec3)var20_17)) {
                shouldRemove = true;
                break;
            }
            Vec3 disp = var20_17.m_82546_(currentStart);
            AABB currentMovementRegion = this.m_20191_().m_82369_(disp).m_82400_(1.0).m_82383_(currentStart.m_82546_(pos));
            Vec3 endStart = currentStart;
            void endCopy = var20_17;
            AABB thisBB = this.m_20191_();
            for (Entity target : this.m_9236_().m_45933_((Entity)this, currentMovementRegion)) {
                AABB targetBB;
                if (projCtx.hasHitEntity(target) || !this.m_5603_(target) || !(targetBB = target.m_20191_()).m_82381_(thisBB) && !targetBB.m_82400_(reach).m_82371_(endStart, (Vec3)endCopy).isPresent()) continue;
                projCtx.addEntity(target);
            }
            if (stop) break;
            currentStart = var20_17;
            t -= disp.m_82553_() * vmRecip;
            if (blockHitResult.m_6662_() != HitResult.Type.MISS) {
                BlockPos bpos = blockHitResult.m_82425_().m_7949_();
                BlockState state = this.m_9236_().m_46745_(bpos).m_8055_(bpos);
                ImpactResult result = this.calculateBlockPenetration(projCtx, state, blockHitResult);
                switch (result.kinematics) {
                    case PENETRATE: {
                        this.lastPenetratedBlock = state;
                        this.penetrationTime = 2;
                        break;
                    }
                    case BOUNCE: {
                        this.m_20256_(trajectory.m_82490_(1.0 - t));
                        Vec3 normal = CBCUtils.getSurfaceNormalVector(this.m_9236_(), blockHitResult);
                        double elasticity = 1.7f;
                        this.nextVelocity = trajectory.m_82546_(normal.m_82490_(normal.m_82526_(trajectory) * elasticity));
                        this.setLocalSoundCooldown(3);
                        stop = true;
                        break;
                    }
                    case STOP: {
                        this.m_20256_(trajectory.m_82490_(1.0 - t));
                        this.nextVelocity = Vec3.f_82478_;
                        this.lastPenetratedBlock = state;
                        this.penetrationTime = 2;
                        this.setLocalSoundCooldown(3);
                        stop = true;
                    }
                }
                shouldRemove |= result.shouldRemove;
            }
            if (shouldRemove || stop || t <= 0.0) break;
        }
        for (Entity entity : projCtx.hitEntities()) {
            shouldRemove |= this.onHitEntity(entity, projCtx);
        }
        if (!this.m_9236_().f_46443_) {
            if (projCtx.griefState() != CBCCfgMunitions.GriefState.NO_DAMAGE) {
                Vec3 oldVel = this.m_20184_();
                for (Map.Entry<BlockPos, Float> entry : projCtx.getQueuedExplosions().entrySet()) {
                    Vec3 impactPos = Vec3.m_82512_((Vec3i)((Vec3i)entry.getKey()));
                    ImpactExplosion explosion = new ImpactExplosion(this.m_9236_(), (Entity)this, this.indirectArtilleryFire(false), impactPos.f_82479_, impactPos.f_82480_, impactPos.f_82481_, entry.getValue().floatValue(), Level.ExplosionInteraction.BLOCK);
                    CreateBigCannons.handleCustomExplosion(this.m_9236_(), explosion);
                }
                this.m_20256_(oldVel);
            }
            for (ClientboundPlayBlockHitEffectPacket clientboundPlayBlockHitEffectPacket : projCtx.getPlayedEffects()) {
                NetworkPlatform.sendToClientTracking(clientboundPlayBlockHitEffectPacket, (Entity)this);
            }
        }
        if (!this.m_9236_().f_46443_ || !stop) {
            this.orientation = trajectory;
        }
        if (shouldRemove) {
            this.removeNextTick = true;
        }
    }

    protected boolean canHitSurface() {
        return this.lastPenetratedBlock.m_60795_() && this.penetrationTime == 0;
    }

    protected boolean onClip(ProjectileContext ctx, Vec3 start, Vec3 end) {
        return false;
    }

    protected abstract ImpactResult calculateBlockPenetration(ProjectileContext var1, BlockState var2, BlockHitResult var3);

    protected boolean onImpactFluid(ProjectileContext projectileContext, BlockState blockState, FluidState fluidState, Vec3 impactPos, BlockHitResult fluidHitResult) {
        boolean bounced;
        Vec3 pos = this.m_20182_();
        Vec3 accel = this.getForces(this.m_20182_(), this.m_20184_());
        Vec3 curVel = this.m_20184_().m_82549_(accel);
        Vec3 normal = CBCUtils.getSurfaceNormalVector(this.m_9236_(), fluidHitResult);
        double incidence = Math.max(0.0, curVel.m_82541_().m_82526_(normal.m_82548_()));
        double velMag = curVel.m_82553_();
        double mass = this.getProjectileMass();
        double incidentVel = velMag * incidence;
        double momentum = mass * incidentVel;
        double projectileDeflection = this.getBallisticProperties().deflection();
        double fluidDensity = FluidDragHandler.getFluidDrag(fluidState);
        boolean canBounce = (Boolean)CBCConfigs.SERVER.munitions.projectilesCanBounce.get();
        double baseChance = CBCConfigs.SERVER.munitions.baseProjectileFluidBounceChance.getF();
        boolean criticalAngle = projectileDeflection > 0.01 && incidence <= projectileDeflection;
        boolean buoyant = fluidDensity > 0.01 && momentum < fluidDensity;
        double incidenceFactor = criticalAngle ? Math.max(0.0, 1.0 - incidence / projectileDeflection) : 0.0;
        double massFactor = buoyant ? 0.0 : Math.max(0.0, 1.0 - momentum / fluidDensity);
        double chance = Math.max(baseChance, incidenceFactor * massFactor);
        boolean bl = bounced = canBounce && criticalAngle && buoyant && this.m_9236_().m_213780_().m_188500_() < chance;
        if (bounced) {
            this.m_20256_(fluidHitResult.m_82450_().m_82546_(pos));
            double elasticity = 1.7f;
            this.nextVelocity = curVel.m_82546_(normal.m_82490_(normal.m_82526_(curVel) * elasticity));
        }
        if (!this.m_9236_().f_46443_) {
            Vec3 effectNormal = bounced ? normal.m_82490_(incidentVel) : curVel.m_82548_();
            Vec3 fluidExplosionPos = fluidHitResult.m_82450_();
            projectileContext.addPlayedEffect(new ClientboundPlayBlockHitEffectPacket(blockState, this.m_6095_(), bounced, true, fluidExplosionPos.f_82479_, fluidExplosionPos.f_82480_, fluidExplosionPos.f_82481_, (float)effectNormal.f_82479_, (float)effectNormal.f_82480_, (float)effectNormal.f_82481_));
        }
        return bounced;
    }

    protected boolean onHitEntity(Entity entity, ProjectileContext projectileContext) {
        if (this.getProjectileMass() <= 0.0f) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            EntityDamagePropertiesComponent properties = this.getDamageProperties();
            entity.m_20256_(this.m_20184_().m_82490_((double)this.getKnockback(entity)));
            DamageSource source = this.getEntityDamage(entity);
            if (properties == null || properties.ignoresInvulnerability()) {
                entity.f_19802_ = 0;
            }
            entity.m_6469_(source, this.damage);
            if (properties == null || !properties.rendersInvulnerable()) {
                entity.f_19802_ = 0;
            }
            float penalty = entity.m_6084_() ? 2.0f : 0.2f;
            this.setProjectileMass(Math.max(this.getProjectileMass() - penalty, 0.0f));
        }
        return this.onImpact((HitResult)new EntityHitResult(entity), new ImpactResult(ImpactResult.KinematicOutcome.PENETRATE, false), projectileContext);
    }

    protected boolean onImpact(HitResult hitResult, ImpactResult impactResult, ProjectileContext projectileContext) {
        return false;
    }

    protected DamageSource getEntityDamage(Entity entity) {
        return this.indirectArtilleryFire(this.getDamageProperties().ignoresEntityArmor());
    }

    protected float getKnockback(Entity target) {
        return this.getDamageProperties().knockback();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(PROJECTILE_MASS, (Object)Float.valueOf(0.0f));
    }

    public void setInGround(boolean inGround) {
        if (inGround) {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(ID_FLAGS) | 1)));
        } else {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 0xFE)));
        }
        super.m_6853_(inGround);
    }

    public boolean isInGround() {
        return ((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 1) != 0;
    }

    public void setGroundPos(@Nullable Vec3 groundPos) {
        this.inGroundPos = groundPos;
    }

    @Nullable
    public Vec3 getGroundPos() {
        return this.inGroundPos;
    }

    public void m_6853_(boolean onGround) {
        this.setInGround(onGround);
    }

    private boolean shouldFall() {
        return this.isInGround() && this.inGroundPos != null && this.m_9236_().m_45772_(new AABB(this.inGroundPos, this.inGroundPos).m_82400_(0.06));
    }

    public void updateKinematics(ClientboundPreciseMotionSyncPacket packet) {
        if (this.m_20184_().m_82556_() > 1.0E-4) {
            this.orientation = this.m_20184_();
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("ProjectileMass", this.getProjectileMass());
        tag.m_128379_("InGround", this.isInGround());
        if (this.inGroundPos != null) {
            tag.m_128365_("InGroundPos", (Tag)this.m_20063_(new double[]{this.inGroundPos.f_82479_, this.inGroundPos.f_82480_, this.inGroundPos.f_82481_}));
        }
        tag.m_128350_("Damage", this.damage);
        if (this.nextVelocity != null) {
            tag.m_128365_("NextMotion", (Tag)this.m_20063_(new double[]{this.nextVelocity.f_82479_, this.nextVelocity.f_82480_, this.nextVelocity.f_82481_}));
        }
        if (this.orientation != null) {
            tag.m_128365_("Orientation", (Tag)this.m_20063_(new double[]{this.orientation.f_82479_, this.orientation.f_82480_, this.orientation.f_82481_}));
        }
        tag.m_128365_("LastPenetration", (Tag)NbtUtils.m_129202_((BlockState)this.lastPenetratedBlock));
        if (this.removeNextTick) {
            tag.m_128379_("RemoveNextTick", true);
        }
    }

    public void m_7378_(CompoundTag tag) {
        ListTag posTag;
        ListTag orientationTag;
        ListTag nextMotion;
        super.m_7378_(tag);
        this.setProjectileMass(tag.m_128457_("ProjectileMass"));
        this.setInGround(tag.m_128471_("InGround"));
        this.damage = tag.m_128457_("Damage");
        ListTag motionTag = tag.m_128437_("Motion", 6);
        this.m_20334_(motionTag.m_128772_(0), motionTag.m_128772_(1), motionTag.m_128772_(2));
        this.nextVelocity = tag.m_128425_("NextMotion", 9) ? ((nextMotion = tag.m_128437_("NextMotion", 6)).size() == 3 ? new Vec3(nextMotion.m_128772_(0), nextMotion.m_128772_(1), nextMotion.m_128772_(2)) : null) : null;
        this.orientation = tag.m_128425_("Orientation", 9) ? ((orientationTag = tag.m_128437_("Orientation", 6)).size() == 3 ? new Vec3(orientationTag.m_128772_(0), orientationTag.m_128772_(1), orientationTag.m_128772_(2)) : null) : this.m_20184_();
        this.inGroundPos = tag.m_128425_("InGroundPos", 9) ? ((posTag = tag.m_128437_("InGroundPos", 6)).size() == 3 ? new Vec3(posTag.m_128772_(0), posTag.m_128772_(1), posTag.m_128772_(2)) : null) : null;
        this.lastPenetratedBlock = tag.m_128425_("LastPenetration", 10) ? NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(CBCRegistryUtils.getBlockRegistryKey()), (CompoundTag)tag.m_128469_("LastPenetration")) : Blocks.f_50016_.m_49966_();
        this.removeNextTick = tag.m_128441_("RemoveNextTick");
    }

    public void baseWriteSpawnData(FriendlyByteBuf buf) {
        Vec3 vel = this.m_20184_();
        Vec3 orientation = this.orientation == null ? vel : this.orientation;
        buf.writeFloat(this.m_146909_()).writeFloat(this.m_146908_()).writeDouble(vel.f_82479_).writeDouble(vel.f_82480_).writeDouble(vel.f_82481_).writeDouble(orientation.f_82479_).writeDouble(orientation.f_82480_).writeDouble(orientation.f_82481_);
    }

    public void baseReadSpawnData(FriendlyByteBuf buf) {
        this.m_146926_(buf.readFloat());
        this.m_146922_(buf.readFloat());
        this.m_20334_(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.orientation = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void setProjectileMass(float power) {
        this.f_19804_.m_135381_(PROJECTILE_MASS, (Object)Float.valueOf(power));
    }

    public float getProjectileMass() {
        return ((Float)this.f_19804_.m_135370_(PROJECTILE_MASS)).floatValue();
    }

    public static void build(EntityType.Builder<? extends AbstractCannonProjectile> builder) {
        builder.m_20702_(16).m_20717_(1).m_20719_().m_20699_(0.8f, 0.8f);
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return 0.0f;
    }

    protected AABB m_142242_() {
        AABB box = super.m_142242_();
        return box.m_82386_(0.0, -box.m_82376_() * 0.5, 0.0);
    }

    public Vec3 m_7371_(float partialTicks) {
        Vec3 eyePos = super.m_7371_(partialTicks);
        return this.isInGround() && this.orientation != null ? eyePos.m_82546_(this.orientation.m_82541_().m_82490_(0.1)) : eyePos;
    }

    protected double getGravity() {
        return this.m_20068_() ? 0.0 : this.getBallisticProperties().gravity() * DimensionMunitionPropertiesHandler.getProperties(this.m_9236_()).gravityMultiplier();
    }

    protected double getDragForce() {
        BallisticPropertiesComponent properties = this.getBallisticProperties();
        double vel = this.m_20184_().m_82553_();
        double formDrag = properties.drag();
        double density = DimensionMunitionPropertiesHandler.getProperties(this.m_9236_()).dragMultiplier();
        FluidState fluidState = this.m_9236_().m_6425_(this.m_20183_());
        if (!fluidState.m_76178_()) {
            density += FluidDragHandler.getFluidDrag(fluidState);
        }
        double drag = formDrag * density * vel;
        if (properties.isQuadraticDrag()) {
            drag *= vel;
        }
        return Math.min(drag, vel);
    }

    @Nonnull
    protected abstract BallisticPropertiesComponent getBallisticProperties();

    public void setChargePower(float power) {
    }

    public boolean m_5603_(Entity entity) {
        if (!super.m_5603_(entity)) {
            return false;
        }
        if (entity instanceof Projectile) {
            return false;
        }
        return !this.untouchableEntities.containsKey(entity);
    }

    public void addUntouchableEntity(Entity entity, int duration) {
        if (entity.m_213877_()) {
            return;
        }
        if (duration < 1) {
            throw new IllegalArgumentException("Use #addAlwaysUntouchableEntity when duration < 1 (was " + duration + ")");
        }
        this.untouchableEntities.put(entity, duration);
    }

    public void addAlwaysUntouchableEntity(Entity entity) {
        this.untouchableEntities.put(entity, -1);
    }

    public void removeUntouchableEntity(Entity entity) {
        this.untouchableEntities.remove(entity);
    }

    public boolean canLingerInGround() {
        return false;
    }

    public DamageSource indirectArtilleryFire(boolean bypassArmor) {
        return new CannonDamageSource((Holder<DamageType>)CannonDamageSource.getDamageRegistry(this.m_9236_()).m_246971_(CBCDamageTypes.CANNON_PROJECTILE), bypassArmor);
    }

    public record ImpactResult(KinematicOutcome kinematics, boolean shouldRemove) {

        public static enum KinematicOutcome {
            PENETRATE,
            STOP,
            BOUNCE;

        }
    }
}

