/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.explosions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.explosions.FlakCloudParticleData;
import rbasamoyai.createbigcannons.effects.particles.smoke.FlakSmokeParticleData;

public class FlakCloudParticle
extends NoRenderParticle {
    private final List<TrailSubparticle> trails = new LinkedList<TrailSubparticle>();

    FlakCloudParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
        super(level, x, y, z, dx, dy, dz);
        if (((Boolean)CBCConfigs.CLIENT.showExtraFlakTrails.get()).booleanValue()) {
            int count = switch (CBCClientCommon.getParticleStatus()) {
                default -> throw new IncompatibleClassChangeError();
                case ParticleStatus.ALL -> 12 + level.f_46441_.m_188503_(5);
                case ParticleStatus.DECREASED -> 4 + level.f_46441_.m_188503_(3);
                case ParticleStatus.MINIMAL -> 0;
            };
            for (int i = 0; i < count; ++i) {
                double dx1 = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                double dy1 = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                double dz1 = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                double rx = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                double ry = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                double rz = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                int lifetime = 5;
                this.trails.add(new TrailSubparticle(new Vec3(rx, ry, rz).m_82490_(0.25), new Vec3(dx1, dy1, dz1).m_82490_(2.0), 0.5, lifetime));
            }
        }
        this.f_107215_ = dx;
        this.f_107216_ = dy;
        this.f_107217_ = dz;
    }

    public void m_5989_() {
        int count;
        if (!((Boolean)CBCConfigs.CLIENT.showFlakClouds.get()).booleanValue()) {
            this.m_107274_();
            return;
        }
        ParticleStatus status = CBCClientCommon.getParticleStatus();
        switch (status) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ALL: {
                int n = 30;
                break;
            }
            case DECREASED: {
                int n = 20;
                break;
            }
            case MINIMAL: {
                int n = count = 10;
            }
        }
        if (this.f_107224_ == 0) {
            double rz;
            double ry;
            double rx;
            double dz;
            double dy;
            double dx;
            int i;
            for (i = 0; i < count; ++i) {
                dx = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                dy = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                dz = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                rx = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                ry = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                rz = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                int lifetime = 45 + this.f_107223_.m_188503_(80);
                this.f_107208_.m_6493_((ParticleOptions)new FlakSmokeParticleData(lifetime, 3.0f), true, this.f_107212_ + rx * 0.25, this.f_107213_ + ry * 0.25, this.f_107214_ + rz * 0.25, dx * 0.5, dy * 0.5, dz * 0.5);
            }
            if (status == ParticleStatus.ALL && ((Boolean)CBCConfigs.CLIENT.showExtraFlakCloudFlames.get()).booleanValue()) {
                for (i = 0; i < 20; ++i) {
                    dx = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                    dy = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                    dz = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                    rx = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                    ry = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                    rz = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                    this.f_107208_.m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, this.f_107212_ + rx * 0.25, this.f_107213_ + ry * 0.25, this.f_107214_ + rz * 0.25, dx * 0.3, dy * 0.3, dz * 0.3);
                }
            }
            if (status == ParticleStatus.ALL && ((Boolean)CBCConfigs.CLIENT.showExtraFlakCloudShockwave.get()).booleanValue()) {
                this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
            }
        }
        if (status != ParticleStatus.MINIMAL) {
            int trailSteps = status == ParticleStatus.ALL ? 5 : 2;
            Iterator<TrailSubparticle> iter = this.trails.iterator();
            while (iter.hasNext()) {
                TrailSubparticle trail = iter.next();
                if (this.f_107224_ > trail.lifetime) {
                    iter.remove();
                    continue;
                }
                Vec3 origin = trail.calculateDisplacement(this.f_107224_);
                Vec3 next = trail.calculateDisplacement(this.f_107224_ + 1);
                for (int i = 0; i <= trailSteps; ++i) {
                    Vec3 pos = origin.m_165921_(next, (double)i / (double)trailSteps).m_82520_(this.f_107212_, this.f_107213_, this.f_107214_);
                    double dx = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                    double dy = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                    double dz = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                    double rx = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                    double ry = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                    double rz = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                    int lifetime = 20 + this.f_107223_.m_188503_(5);
                    this.f_107208_.m_6493_((ParticleOptions)new FlakSmokeParticleData(lifetime, 1.0f), true, pos.f_82479_ + rx * 0.25, pos.f_82480_ + ry * 0.25, pos.f_82481_ + rz * 0.25, dx * 0.01, dy * 0.01, dz * 0.01);
                }
            }
        }
        super.m_5989_();
    }

    private record TrailSubparticle(Vec3 displacement, Vec3 vel, double drag, int lifetime) {
        public Vec3 calculateDisplacement(int ticks) {
            if (ticks <= 0 || this.drag <= 0.01) {
                return this.displacement;
            }
            if (this.drag == 1.0) {
                return this.displacement.m_82549_(this.vel.m_82490_((double)ticks));
            }
            double geo = (1.0 - Math.pow(this.drag, ticks)) / (1.0 - this.drag);
            return this.displacement.m_82549_(this.vel.m_82490_(geo));
        }
    }

    public static class Provider
    implements ParticleProvider<FlakCloudParticleData> {
        public Particle createParticle(FlakCloudParticleData data, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            FlakCloudParticle particle = new FlakCloudParticle(level, x, y, z, dx, dy, dz);
            particle.m_107250_(0.25f, 0.25f);
            particle.m_107257_(30);
            return particle;
        }
    }
}

