/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.compat.cbc;

import com.happysg.radar.mixin.AbstractCannonAccessor;
import com.happysg.radar.mixin.AutoCannonAccessor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.MountedAutocannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.MountedBigCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.IAutocannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.material.AutocannonMaterialProperties;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.munitions.big_cannon.AbstractBigCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.ProjectileBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCannonPropellantBlock;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;

public class CannonUtil {
    public static int getBarrelLength(AbstractMountedCannonContraption cannon) {
        if (cannon == null) {
            return 0;
        }
        if (cannon.initialOrientation() == Direction.WEST || cannon.initialOrientation() == Direction.NORTH) {
            return ((AbstractCannonAccessor)cannon).getBackExtensionLength();
        }
        return ((AbstractCannonAccessor)cannon).getFrontExtensionLength();
    }

    public static int getChargePower(ServerLevel level, PitchOrientedContraptionEntity contraptionEntity) {
        if (contraptionEntity == null) {
            return 0;
        }
        Map presentBlockEntities = contraptionEntity.getContraption().presentBlockEntities;
        int chargePower = 0;
        for (BlockEntity blockEntity : presentBlockEntities.values()) {
            if (!(blockEntity instanceof IBigCannonBlockEntity)) continue;
            IBigCannonBlockEntity cannonBlockEntity = (IBigCannonBlockEntity)blockEntity;
            BigCannonBehavior behavior = (BigCannonBehavior)cannonBlockEntity.cannonBehavior();
            StructureTemplate.StructureBlockInfo containedBlockInfo = behavior.block();
            Block block = containedBlockInfo.f_74676_().m_60734_();
            if (block instanceof BigCannonPropellantBlock) {
                BigCannonPropellantBlock propellantBlock = (BigCannonPropellantBlock)block;
                chargePower += (int)propellantBlock.getChargePower(containedBlockInfo);
                continue;
            }
            if (!(block instanceof ProjectileBlock)) continue;
            ProjectileBlock projectileBlock = (ProjectileBlock)block;
            AbstractBigCannonProjectile projectile = projectileBlock.getProjectile((Level)level, Collections.singletonList(containedBlockInfo));
            chargePower += (int)projectile.addedChargePower();
        }
        return chargePower;
    }

    public static float getInitialVelocity(AbstractMountedCannonContraption cannon, ServerLevel level) {
        if (cannon instanceof MountedBigCannonContraption) {
            MountedBigCannonContraption bigCannon = (MountedBigCannonContraption)cannon;
            if (bigCannon.entity instanceof PitchOrientedContraptionEntity) {
                return CannonUtil.getChargePower(level, (PitchOrientedContraptionEntity)bigCannon.entity);
            }
        }
        if (cannon instanceof MountedAutocannonContraption) {
            MountedAutocannonContraption auto = (MountedAutocannonContraption)cannon;
            return CannonUtil.getACSpeed(auto);
        }
        return 0.0f;
    }

    public static double getProjectileGravity(AbstractMountedCannonContraption cannon, ServerLevel level) {
        if (CannonUtil.isAutoCannon(cannon)) {
            return -0.025;
        }
        Map presentBlockEntities = cannon.presentBlockEntities;
        for (BlockEntity blockEntity : presentBlockEntities.values()) {
            BallisticPropertiesComponent ballisticProperties;
            IBigCannonBlockEntity cannonBlockEntity;
            BigCannonBehavior behavior;
            StructureTemplate.StructureBlockInfo containedBlockInfo;
            Block block;
            if (!(blockEntity instanceof IBigCannonBlockEntity) || !((block = (containedBlockInfo = (behavior = (BigCannonBehavior)(cannonBlockEntity = (IBigCannonBlockEntity)blockEntity).cannonBehavior()).block()).f_74676_().m_60734_()) instanceof ProjectileBlock)) continue;
            ProjectileBlock projectileBlock = (ProjectileBlock)block;
            AbstractBigCannonProjectile projectile = projectileBlock.getProjectile((Level)level, Collections.singletonList(containedBlockInfo));
            try {
                Method method = projectile.getClass().getDeclaredMethod("getBallisticProperties", new Class[0]);
                method.setAccessible(true);
                ballisticProperties = (BallisticPropertiesComponent)method.invoke((Object)projectile, new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return 0.05;
            }
            return ballisticProperties.gravity();
        }
        return 0.05;
    }

    public static double getProjectileDrag(AbstractMountedCannonContraption cannon, ServerLevel level) {
        Map presentBlockEntities = cannon.presentBlockEntities;
        for (BlockEntity blockEntity : presentBlockEntities.values()) {
            BallisticPropertiesComponent ballisticProperties;
            IBigCannonBlockEntity cannonBlockEntity;
            BigCannonBehavior behavior;
            StructureTemplate.StructureBlockInfo containedBlockInfo;
            Block block;
            if (!(blockEntity instanceof IBigCannonBlockEntity) || !((block = (containedBlockInfo = (behavior = (BigCannonBehavior)(cannonBlockEntity = (IBigCannonBlockEntity)blockEntity).cannonBehavior()).block()).f_74676_().m_60734_()) instanceof ProjectileBlock)) continue;
            ProjectileBlock projectileBlock = (ProjectileBlock)block;
            AbstractBigCannonProjectile projectile = projectileBlock.getProjectile((Level)level, Collections.singletonList(containedBlockInfo));
            try {
                Method method = projectile.getClass().getDeclaredMethod("getBallisticProperties", new Class[0]);
                method.setAccessible(true);
                ballisticProperties = (BallisticPropertiesComponent)method.invoke((Object)projectile, new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return 0.01;
            }
            return ballisticProperties.drag();
        }
        return 0.01;
    }

    public static boolean isBigCannon(AbstractMountedCannonContraption cannon) {
        return cannon instanceof MountedBigCannonContraption;
    }

    public static boolean isAutoCannon(AbstractMountedCannonContraption cannon) {
        return cannon instanceof MountedAutocannonContraption;
    }

    public static int getChargeCount(MountedBigCannonContraption cannon) {
        if (cannon.isDropMortar()) {
            return 0;
        }
        return 1;
    }

    public static float getACSpeed(MountedAutocannonContraption autocannon) {
        if (autocannon == null) {
            return 0.0f;
        }
        if (((AutoCannonAccessor)autocannon).getMaterial() == null) {
            return 0.0f;
        }
        AutocannonMaterialProperties properties = ((AutoCannonAccessor)autocannon).getMaterial().properties();
        float speed = properties.baseSpeed();
        BlockPos currentPos = autocannon.getStartPos().m_121945_(autocannon.initialOrientation());
        int barrelTravelled = 0;
        while (autocannon.presentBlockEntities.get(currentPos) instanceof IAutocannonBlockEntity) {
            if (++barrelTravelled <= properties.maxSpeedIncreases()) {
                speed += properties.speedIncreasePerBarrel();
            }
            if (barrelTravelled > properties.maxBarrelLength()) break;
            currentPos = currentPos.m_121945_(autocannon.initialOrientation());
        }
        return speed;
    }
}

