/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.compat.cbc;

import com.happysg.radar.compat.cbc.CannonUtil;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.BrentSolver;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;

public class CannonTargeting {
    public static List<Double> calculatePitch(double speed, Vec3 targetPos, Vec3 originPos, int barrelLength, double drag, double gravity) {
        if (speed == 0.0) {
            return null;
        }
        double d1 = targetPos.f_82479_ - originPos.f_82479_;
        double d2 = targetPos.f_82481_ - originPos.f_82481_;
        double distance = Math.abs(Math.sqrt(d1 * d1 + d2 * d2));
        double d3 = targetPos.f_82480_ - originPos.f_82480_;
        double g = Math.abs(gravity);
        UnivariateFunction diffFunction = theta -> {
            double thetaRad = Math.toRadians(theta);
            double dX = distance - Math.cos(thetaRad) * (double)barrelLength;
            double dY = d3 - Math.sin(thetaRad) * (double)barrelLength;
            double log = Math.log(1.0 - drag * dX / (speed * Math.cos(thetaRad)));
            if (Double.isInfinite(log)) {
                log = Double.NaN;
            }
            double y = dX * Math.tan(thetaRad) + dX * g / (drag * speed * Math.cos(thetaRad)) + g * log / (drag * drag);
            return y - dY;
        };
        BrentSolver solver = new BrentSolver(1.0E-32);
        double start = -90.0;
        double end = 90.0;
        double step = 1.0;
        ArrayList<Double> roots = new ArrayList<Double>();
        double prevValue = diffFunction.value(start);
        double prevTheta = start;
        for (double theta2 = start + step; theta2 <= end; theta2 += step) {
            double currValue = diffFunction.value(theta2);
            if (prevValue * currValue < 0.0) {
                try {
                    double root = solver.solve(1000, diffFunction, prevTheta, theta2);
                    roots.add(root);
                }
                catch (Exception e) {
                    return null;
                }
            }
            prevTheta = Double.isNaN(currValue) ? prevTheta : theta2;
            prevValue = Double.isNaN(currValue) ? prevValue : currValue;
        }
        if (roots.isEmpty()) {
            return null;
        }
        return roots;
    }

    public static List<Double> calculatePitch(CannonMountBlockEntity mount, Vec3 targetPos, ServerLevel level) {
        if (mount == null || targetPos == null) {
            return null;
        }
        PitchOrientedContraptionEntity contraption = mount.getContraption();
        if (contraption == null) {
            return null;
        }
        Contraption contraption2 = contraption.getContraption();
        if (!(contraption2 instanceof AbstractMountedCannonContraption)) {
            return null;
        }
        AbstractMountedCannonContraption cannonContraption = (AbstractMountedCannonContraption)contraption2;
        float chargePower = CannonUtil.getInitialVelocity(cannonContraption, level);
        Vec3 mountPos = mount.m_58899_().m_6630_(2).m_252807_();
        int barrelLength = CannonUtil.getBarrelLength(cannonContraption);
        double drag = CannonUtil.getProjectileDrag((AbstractMountedCannonContraption)contraption.getContraption(), level);
        double gravity = CannonUtil.getProjectileGravity((AbstractMountedCannonContraption)contraption.getContraption(), level);
        return CannonTargeting.calculatePitch(chargePower, targetPos, mountPos, barrelLength, drag, gravity);
    }
}

