/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.radar.bearing;

import com.happysg.radar.config.RadarConfig;
import com.jozufozu.flywheel.util.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.Ship;

public record VSRadarTracks(String id, Vec3 position, long scannedTime, Color color) {
    public VSRadarTracks(Ship serverShip, Level level) {
        this(String.valueOf(serverShip.getId()), VSRadarTracks.getPosition(serverShip), level.m_46467_(), new Color(((Integer)RadarConfig.client().VS2Color.get()).intValue()));
    }

    private static Vec3 getPosition(Ship serverShip) {
        Vector3d vecD = serverShip.getWorldAABB().center(new Vector3d());
        return new Vec3(vecD.x, vecD.y, vecD.z);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("x", this.position.f_82479_);
        tag.m_128347_("y", this.position.f_82480_);
        tag.m_128347_("z", this.position.f_82481_);
        tag.m_128356_("scannedTime", this.scannedTime);
        tag.m_128405_("color", this.color.getRGB());
        tag.m_128359_("id", this.id);
        return tag;
    }

    public static VSRadarTracks deserializeNBT(CompoundTag tag) {
        return new VSRadarTracks(tag.m_128461_("id"), new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z")), tag.m_128454_("scannedTime"), new Color(tag.m_128451_("color")));
    }

    public static CompoundTag serializeNBTList(Collection<VSRadarTracks> tracks) {
        ListTag list = new ListTag();
        for (VSRadarTracks track : tracks) {
            list.add((Object)track.serializeNBT());
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("tracks", (Tag)list);
        return tag;
    }

    public static List<VSRadarTracks> deserializeListNBT(CompoundTag tag) {
        ArrayList<VSRadarTracks> tracks = new ArrayList<VSRadarTracks>();
        ListTag list = tag.m_128437_("tracks", 10);
        for (int i = 0; i < list.size(); ++i) {
            tracks.add(VSRadarTracks.deserializeNBT(list.m_128728_(i)));
        }
        return tracks;
    }
}

