/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.radar.bearing;

import com.happysg.radar.config.RadarConfig;
import com.jozufozu.flywheel.util.Color;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;

public record RadarTrack(String entityId, Vec3 position, long scannedTime, Color color, boolean contraption, int id, EntityType entityType) {
    public RadarTrack(Entity entity) {
        this(entity.m_20149_(), RadarTrack.getPosition(entity), entity.m_9236_().m_46467_(), RadarTrack.getColor(entity), RadarTrack.isContraption(entity), entity.m_19879_(), RadarTrack.getEntityType(entity));
    }

    private static EntityType getEntityType(Entity entity) {
        if (entity instanceof Player) {
            return EntityType.PLAYER;
        }
        if (entity instanceof Projectile) {
            return EntityType.PROJECTILE;
        }
        if (entity instanceof Animal) {
            return EntityType.ANIMAL;
        }
        if (entity instanceof Mob) {
            return EntityType.MOB;
        }
        if (entity instanceof AbstractContraptionEntity) {
            return EntityType.CONTRAPTION;
        }
        return EntityType.MISC;
    }

    private static Vec3 getPosition(Entity entity) {
        if (entity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity entity1 = (AbstractContraptionEntity)entity;
            return entity1.getContraption().anchor.m_252807_();
        }
        return entity.m_146892_();
    }

    private static Color getColor(Entity entity) {
        if (entity instanceof Player) {
            return new Color(((Integer)RadarConfig.client().playerColor.get()).intValue());
        }
        if (entity instanceof Animal) {
            return new Color(((Integer)RadarConfig.client().friendlyColor.get()).intValue());
        }
        if (entity instanceof Enemy) {
            return new Color(((Integer)RadarConfig.client().hostileColor.get()).intValue());
        }
        if (entity instanceof Projectile) {
            return new Color(((Integer)RadarConfig.client().projectileColor.get()).intValue());
        }
        if (entity instanceof AbstractContraptionEntity) {
            return new Color(((Integer)RadarConfig.client().contraptionColor.get()).intValue());
        }
        return new Color(((Integer)RadarConfig.client().neutralEntityColor.get()).intValue());
    }

    private static boolean isContraption(Entity entity) {
        return entity instanceof AbstractContraptionEntity;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("entityId", this.entityId);
        tag.m_128347_("x", this.position.f_82479_);
        tag.m_128347_("y", this.position.f_82480_);
        tag.m_128347_("z", this.position.f_82481_);
        tag.m_128356_("scannedTime", this.scannedTime);
        tag.m_128405_("color", this.color.getRGB());
        tag.m_128379_("contraption", this.contraption);
        tag.m_128405_("id", this.id);
        tag.m_128405_("entityType", this.entityType.ordinal());
        return tag;
    }

    public static RadarTrack deserializeNBT(CompoundTag tag) {
        return new RadarTrack(tag.m_128461_("entityId"), new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z")), tag.m_128454_("scannedTime"), new Color(tag.m_128451_("color")), tag.m_128471_("contraption"), tag.m_128451_("id"), EntityType.values()[tag.m_128451_("entityType")]);
    }

    public static CompoundTag serializeNBTList(Collection<RadarTrack> tracks) {
        ListTag list = new ListTag();
        for (RadarTrack track : tracks) {
            list.add((Object)track.serializeNBT());
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("tracks", (Tag)list);
        return tag;
    }

    public static List<RadarTrack> deserializeListNBT(CompoundTag tag) {
        ArrayList<RadarTrack> tracks = new ArrayList<RadarTrack>();
        ListTag list = tag.m_128437_("tracks", 10);
        for (int i = 0; i < list.size(); ++i) {
            tracks.add(RadarTrack.deserializeNBT(list.m_128728_(i)));
        }
        return tracks;
    }

    public static enum EntityType {
        MISC,
        PLAYER,
        PROJECTILE,
        MOB,
        ANIMAL,
        CONTRAPTION,
        VS2;

    }
}

