/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.radar.bearing;

import com.happysg.radar.block.radar.bearing.RadarBearingBlock;
import com.happysg.radar.block.radar.bearing.RadarContraption;
import com.happysg.radar.block.radar.bearing.RadarTrack;
import com.happysg.radar.block.radar.bearing.VSRadarTracks;
import com.happysg.radar.compat.Mods;
import com.happysg.radar.compat.vs2.VS2Utils;
import com.happysg.radar.config.RadarConfig;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.content.kinetics.BlockStressValues;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.Ship;

public class RadarBearingBlockEntity
extends MechanicalBearingBlockEntity {
    private static final int MAX_TRACK_TICKS = 100;
    private int dishCount;
    private boolean creative;
    private Direction receiverFacing = Direction.NORTH;
    Map<String, RadarTrack> entityPositions = new HashMap<String, RadarTrack>();
    Map<String, VSRadarTracks> VSPositions = new HashMap<String, VSRadarTracks>();

    public RadarBearingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.movementMode.setValue(IControlContraption.MovementMode.MOVE_NEVER_PLACE.ordinal());
    }

    public void tick() {
        super.tick();
        if (this.isRunning()) {
            this.scanForEntityTracks();
            this.scanForVSTracks();
        }
        this.clearOldTracks();
        this.notifyUpdate();
    }

    private void clearOldTracks() {
        ArrayList toRemove = new ArrayList();
        long currentTime = this.f_58857_.m_46467_();
        this.entityPositions.forEach((entity, track) -> {
            if (currentTime - track.scannedTime() > 100L || this.f_58857_.m_6815_(track.id()) != null && (this.f_58857_.m_6815_(track.id()).m_213877_() || !this.f_58857_.m_6815_(track.id()).m_6084_())) {
                toRemove.add(entity);
            }
        });
        toRemove.forEach(uuid -> this.entityPositions.remove(uuid));
        if (Mods.VALKYRIENSKIES.isLoaded()) {
            ArrayList toRemoveVS = new ArrayList();
            this.VSPositions.forEach((entity, track) -> {
                if (currentTime - track.scannedTime() > 100L) {
                    toRemoveVS.add(entity);
                }
            });
            toRemoveVS.forEach(uuid -> this.VSPositions.remove(uuid));
        }
    }

    private void scanForEntityTracks() {
        if (this.f_58857_ == null) {
            return;
        }
        List<AABB> AABBs = RadarBearingBlockEntity.splitAABB(this.getRadarAABB(), 999.0);
        AABBs.forEach(aabb -> {
            for (Entity entity : this.f_58857_.m_45933_(null, aabb)) {
                if (!entity.m_6084_() || !this.isEntityInRadarFov(entity.m_20183_())) continue;
                this.entityPositions.put(entity.m_20149_(), new RadarTrack(entity));
            }
        });
    }

    private void scanForVSTracks() {
        if (!Mods.VALKYRIENSKIES.isLoaded()) {
            return;
        }
        if (this.f_58857_ == null) {
            return;
        }
        List<AABB> AABBs = RadarBearingBlockEntity.splitAABB(this.getRadarAABB(), 999.0);
        AABBs.forEach(aabb -> {
            Iterable<Ship> ships = VS2Utils.getLoadedShips(this.f_58857_, aabb);
            if (ships == null) {
                return;
            }
            ships.forEach(serverShip -> {
                Vector3d shipPos = serverShip.getWorldAABB().center(new Vector3d());
                if (this.isEntityInRadarFov(new BlockPos((int)shipPos.x, (int)shipPos.y, (int)shipPos.z))) {
                    this.VSPositions.put(String.valueOf(serverShip.getId()), new VSRadarTracks((Ship)serverShip, this.f_58857_));
                }
            });
        });
    }

    private AABB getRadarAABB() {
        float range = this.getRange();
        BlockPos radarPos = VS2Utils.getWorldPos((BlockEntity)this);
        double xOffset = (double)range * Math.sin(Math.toRadians(this.getGlobalAngle()));
        double zOffset = (double)range * Math.cos(Math.toRadians(this.getGlobalAngle()));
        return new AABB((double)radarPos.m_123341_() - xOffset, (double)(radarPos.m_123342_() - (Integer)RadarConfig.server().radarYScanRange.get()), (double)radarPos.m_123343_() - zOffset, (double)radarPos.m_123341_() + xOffset, (double)(radarPos.m_123342_() + (Integer)RadarConfig.server().radarYScanRange.get()), (double)radarPos.m_123343_() + zOffset);
    }

    public static List<AABB> splitAABB(AABB aabb, double maxSize) {
        ArrayList<AABB> result = new ArrayList<AABB>();
        double xMin = aabb.f_82288_;
        double xMax = aabb.f_82291_;
        double yMin = aabb.f_82289_;
        double yMax = aabb.f_82292_;
        double zMin = aabb.f_82290_;
        double zMax = aabb.f_82293_;
        for (double xStart = xMin; xStart < xMax; xStart += maxSize) {
            double xEnd = Math.min(xStart + maxSize, xMax);
            for (double yStart = yMin; yStart < yMax; yStart += maxSize) {
                double yEnd = Math.min(yStart + maxSize, yMax);
                for (double zStart = zMin; zStart < zMax; zStart += maxSize) {
                    double zEnd = Math.min(zStart + maxSize, zMax);
                    result.add(new AABB(xStart, yStart, zStart, xEnd, yEnd, zEnd));
                }
            }
        }
        return result;
    }

    private boolean isEntityInRadarFov(BlockPos entityPos) {
        double relativeAngle;
        float radarAngle = this.getGlobalAngle();
        int fovDegrees = (Integer)RadarConfig.server().radarFOV.get();
        BlockPos radarPos = VS2Utils.getWorldPos((BlockEntity)this);
        double angleToEntity = Math.toDegrees(Math.atan2(entityPos.m_123341_() - radarPos.m_123341_(), radarPos.m_123343_() - entityPos.m_123343_()));
        if (angleToEntity < 0.0) {
            angleToEntity += 360.0;
        }
        return (relativeAngle = Math.abs(angleToEntity - (double)radarAngle)) <= (double)fovDegrees / 2.0;
    }

    public float getGlobalAngle() {
        return (this.receiverFacing.m_122435_() - this.angle + 360.0f) % 360.0f;
    }

    public float getAngularSpeed() {
        if (!((Boolean)RadarConfig.server().gearRadarBearingSpeed.get()).booleanValue()) {
            return super.getAngularSpeed();
        }
        float speed = RadarBearingBlockEntity.convertToAngular((float)this.getSpeed());
        if (this.getSpeed() == 0.0f) {
            speed = 0.0f;
        }
        if (this.f_58857_.f_46443_) {
            speed *= ServerSpeedProvider.get();
            speed += this.clientAngleDiff / 3.0f;
        }
        return speed / (4.0f + (float)(this.getDishCount() / 10));
    }

    public void assemble() {
        if (!(this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof RadarBearingBlock)) {
            return;
        }
        RadarContraption contraption = this.createContraption();
        if (contraption == null) {
            return;
        }
        if (this.isWindmill()) {
            this.award(AllAdvancements.WINDMILL);
        }
        if (contraption.getSailBlocks() >= 128) {
            this.award(AllAdvancements.WINDMILL_MAXED);
        }
        this.updateGeneratedRotation();
        this.updateContraptionData();
        this.notifyUpdate();
    }

    public void disassemble() {
        super.disassemble();
        this.updateContraptionData();
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)BlockStressValues.getImpact((Block)this.getStressConfigKey()) + (float)this.getDishCount();
        return impact;
    }

    private RadarContraption createContraption() {
        RadarContraption contraption = new RadarContraption();
        try {
            if (!contraption.assemble(this.f_58857_, this.m_58899_())) {
                return null;
            }
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return null;
        }
        contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
        this.movedContraption = ControlledContraptionEntity.create((Level)this.f_58857_, (IControlContraption)this, (Contraption)contraption);
        BlockPos anchor = this.getBlockPosition().m_7494_();
        this.movedContraption.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        this.movedContraption.setRotationAxis(Direction.Axis.Y);
        this.f_58857_.m_7967_((Entity)this.movedContraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.m_58899_());
        this.running = true;
        this.angle = 0.0f;
        return contraption;
    }

    private void updateContraptionData() {
        this.dishCount = this.getContraption().map(RadarContraption::getDishCount).orElse(0);
        this.receiverFacing = this.getContraption().map(RadarContraption::getReceiverFacing).orElse(Direction.NORTH);
        this.creative = this.getContraption().map(RadarContraption::isCreative).orElse(false);
        this.notifyUpdate();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((Component)Component.m_237113_((String)("    Dish Count: " + this.dishCount)));
        tooltip.add((Component)Component.m_237113_((String)("    Range: " + this.getRange())));
        return true;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.dishCount = compound.m_128451_("dishCount");
        this.creative = compound.m_128471_("creative");
        if (compound.m_128441_("receiverFacing")) {
            this.receiverFacing = Direction.m_122376_((int)compound.m_128451_("receiverFacing"));
        }
        if (clientPacket && compound.m_128441_("entityPositions")) {
            RadarTrack.deserializeListNBT(compound.m_128469_("entityPositions")).forEach(track -> this.entityPositions.put(track.entityId(), (RadarTrack)track));
        }
        if (clientPacket && Mods.VALKYRIENSKIES.isLoaded()) {
            VSRadarTracks.deserializeListNBT(compound.m_128469_("VSPositions")).forEach(track -> this.VSPositions.put(track.id(), (VSRadarTracks)track));
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("dishCount", this.dishCount);
        compound.m_128379_("creative", this.creative);
        if (this.receiverFacing != null) {
            compound.m_128405_("receiverFacing", this.receiverFacing.m_122411_());
        }
        if (clientPacket) {
            compound.m_128365_("entityPositions", (Tag)RadarTrack.serializeNBTList(this.entityPositions.values()));
        }
        if (clientPacket && Mods.VALKYRIENSKIES.isLoaded()) {
            compound.m_128365_("VSPositions", (Tag)VSRadarTracks.serializeNBTList(this.VSPositions.values()));
        }
    }

    public int getDishCount() {
        return this.dishCount;
    }

    public Optional<RadarContraption> getContraption() {
        return Optional.ofNullable(this.movedContraption).map(AbstractContraptionEntity::getContraption).filter(c -> c instanceof RadarContraption).map(c -> (RadarContraption)((Object)c));
    }

    public float getAngle() {
        return this.angle;
    }

    public Direction getReceiverFacing() {
        return this.receiverFacing;
    }

    public List<RadarTrack> getEntityPositions() {
        return new ArrayList<RadarTrack>(this.entityPositions.values());
    }

    public List<VSRadarTracks> getVS2Positions() {
        return new ArrayList<VSRadarTracks>(this.VSPositions.values());
    }

    public float getRange() {
        if (this.creative) {
            return ((Integer)RadarConfig.server().maxRadarRange.get()).intValue();
        }
        return Math.min((Integer)RadarConfig.server().radarBaseRange.get() + this.dishCount * (Integer)RadarConfig.server().dishRangeIncrease.get(), (Integer)RadarConfig.server().maxRadarRange.get());
    }
}

