/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.monitor;

import com.happysg.radar.block.monitor.MonitorBlock;
import com.happysg.radar.block.monitor.MonitorBlockEntity;
import com.happysg.radar.config.RadarConfig;
import com.happysg.radar.registry.ModBlocks;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class MonitorMultiBlockHelper {
    public static void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pState.m_61143_(MonitorBlock.SHAPE) != MonitorBlock.Shape.SINGLE && !pIsMoving) {
            return;
        }
        BlockPos.m_121921_((AABB)new AABB(pPos).m_82400_((double)((Integer)RadarConfig.server().monitorMaxSize.get()).intValue())).forEach(p -> {
            BlockEntity patt1170$temp = pLevel.m_7702_(p);
            if (patt1170$temp instanceof MonitorBlockEntity) {
                MonitorBlockEntity monitor = (MonitorBlockEntity)patt1170$temp;
                int size = MonitorMultiBlockHelper.getSize(pLevel, p);
                if (size > 1) {
                    MonitorMultiBlockHelper.formMulti(pState, pLevel, monitor.getControllerPos(), size);
                }
            }
        });
    }

    public static void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (ModBlocks.MONITOR.has(pNewState) && !pIsMoving) {
            return;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof MonitorBlockEntity) {
            MonitorBlockEntity monitor = (MonitorBlockEntity)blockEntity;
            MonitorMultiBlockHelper.destroyMulti(pState, pLevel, pPos, monitor.getControllerPos(), monitor.getSize());
        }
    }

    static void formMulti(BlockState pState, Level pLevel, BlockPos pPos, int size) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                MonitorBlock.Shape shape = i == 0 && j == 0 ? MonitorBlock.Shape.LOWER_RIGHT : (i == 0 && j == size - 1 ? MonitorBlock.Shape.LOWER_LEFT : (i == size - 1 && j == 0 ? MonitorBlock.Shape.UPPER_RIGHT : (i == size - 1 && j == size - 1 ? MonitorBlock.Shape.UPPER_LEFT : (i == 0 ? MonitorBlock.Shape.LOWER_CENTER : (i == size - 1 ? MonitorBlock.Shape.UPPER_CENTER : (j == 0 ? MonitorBlock.Shape.MIDDLE_RIGHT : (j == size - 1 ? MonitorBlock.Shape.MIDDLE_LEFT : MonitorBlock.Shape.CENTER)))))));
                Direction facing = (Direction)pLevel.m_8055_(pPos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
                pLevel.m_46597_(pPos.m_6630_(i).m_5484_(facing.m_122427_(), j), (BlockState)pState.m_61124_(MonitorBlock.SHAPE, (Comparable)((Object)shape)));
                BlockEntity blockEntity = pLevel.m_7702_(pPos.m_6630_(i).m_5484_(facing.m_122427_(), j));
                if (!(blockEntity instanceof MonitorBlockEntity)) continue;
                MonitorBlockEntity monitor = (MonitorBlockEntity)blockEntity;
                monitor.setControllerPos(pPos, size);
            }
        }
    }

    private static void destroyMulti(BlockState pState, Level pLevel, BlockPos removedPos, BlockPos controllerPos, int size) {
        MonitorBlockEntity monitor;
        if (size == 1) {
            return;
        }
        BlockEntity blockEntity = pLevel.m_7702_(removedPos);
        if (blockEntity instanceof MonitorBlockEntity && (monitor = (MonitorBlockEntity)blockEntity).getControllerPos().equals((Object)controllerPos)) {
            monitor.setControllerPos(removedPos, 1);
        }
        Direction facing = (Direction)pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                MonitorBlockEntity monitor2;
                BlockEntity blockEntity2;
                BlockPos pos = controllerPos.m_6630_(i).m_5484_(facing.m_122427_(), j);
                if (pos.equals((Object)removedPos) || !((blockEntity2 = pLevel.m_7702_(pos)) instanceof MonitorBlockEntity) || !(monitor2 = (MonitorBlockEntity)blockEntity2).getControllerPos().equals((Object)controllerPos)) continue;
                monitor2.setControllerPos(pos, 1);
                pLevel.m_46597_(pos, (BlockState)pState.m_61124_(MonitorBlock.SHAPE, (Comparable)((Object)MonitorBlock.Shape.SINGLE)));
            }
        }
    }

    public static int getSize(Level pLevel, BlockPos pPos) {
        int i;
        if (!pLevel.m_8055_(pPos).m_60713_((Block)ModBlocks.MONITOR.get())) {
            return 0;
        }
        Direction facing = (Direction)pLevel.m_8055_(pPos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        int potentialsize = 0;
        for (i = 0; i < (Integer)RadarConfig.server().monitorMaxSize.get(); ++i) {
            AtomicBoolean valid = new AtomicBoolean(true);
            BlockPos.m_121940_((BlockPos)pPos, (BlockPos)pPos.m_6630_(i).m_5484_(facing.m_122427_(), i)).forEach(p -> {
                if (!pLevel.m_8055_(p).m_60713_((Block)ModBlocks.MONITOR.get())) {
                    valid.set(false);
                }
            });
            if (!valid.get()) break;
            potentialsize = i + 1;
        }
        if (potentialsize == 1) {
            return 1;
        }
        for (i = 0; i < potentialsize; ++i) {
            for (int j = 0; j < potentialsize; ++j) {
                MonitorBlockEntity monitor;
                BlockEntity be = pLevel.m_7702_(pPos.m_6630_(i).m_5484_(facing.m_122427_(), j));
                if (be instanceof MonitorBlockEntity && (monitor = (MonitorBlockEntity)be).getSize() < potentialsize) continue;
                return Math.min(i, j);
            }
        }
        return potentialsize;
    }

    public static boolean isMulti(Level pLevel, BlockPos pos) {
        if (!pLevel.m_8055_(pos).m_60713_((Block)ModBlocks.MONITOR.get())) {
            return false;
        }
        return MonitorMultiBlockHelper.getSize(pLevel, pos) > 1;
    }

    public static void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
    }
}

