/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.monitor;

import com.happysg.radar.block.monitor.MonitorBlock;
import com.happysg.radar.block.monitor.MonitorBlockEntity;
import com.happysg.radar.block.radar.bearing.RadarBearingBlockEntity;
import com.happysg.radar.block.radar.bearing.RadarTrack;
import com.happysg.radar.block.radar.bearing.VSRadarTracks;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class MonitorInputHandler {
    public static void monitorPlayerHovering(TickEvent.PlayerTickEvent event) {
        MonitorBlockEntity be;
        BlockHitResult result;
        BlockEntity blockEntity;
        Player player = event.player;
        Level level = event.player.m_9236_();
        Vec3 hit = player.m_19907_(5.0, 0.0f, false).m_82450_();
        HitResult hitResult = player.m_19907_(5.0, 0.0f, false);
        if (hitResult instanceof BlockHitResult && (blockEntity = level.m_7702_((result = (BlockHitResult)hitResult).m_82425_())) instanceof MonitorBlockEntity && (blockEntity = level.m_7702_((be = (MonitorBlockEntity)blockEntity).getControllerPos())) instanceof MonitorBlockEntity) {
            float sizeadj;
            MonitorBlockEntity monitor = (MonitorBlockEntity)blockEntity;
            Direction facing = ((Direction)level.m_8055_(monitor.getControllerPos()).m_61143_((Property)MonitorBlock.f_54117_)).m_122427_();
            Direction monitorFacing = (Direction)level.m_8055_(monitor.getControllerPos()).m_61143_((Property)MonitorBlock.f_54117_);
            int size = monitor.getSize();
            Vec3 center = Vec3.m_82512_((Vec3i)monitor.getControllerPos()).m_82520_((double)(facing.m_122429_() * (size - 1)) / 2.0, (double)(size - 1) / 2.0, (double)(facing.m_122431_() * (size - 1)) / 2.0);
            Vec3 relative = hit.m_82546_(center);
            relative = monitor.adjustRelativeVectorForFacing(relative, monitorFacing);
            if (monitor.radarPos == null) {
                return;
            }
            Vec3 RadarPos = monitor.radarPos.m_252807_();
            float range = monitor.getRadar().map(RadarBearingBlockEntity::getRange).orElse(Float.valueOf(0.0f)).floatValue();
            float f = sizeadj = size == 1 ? 0.5f : (float)(size - 1) / 2.0f;
            if (size == 2) {
                sizeadj = 0.75f;
            }
            Vec3 selected = RadarPos.m_82549_(relative.m_82490_((double)(range / sizeadj)));
            monitor.getRadar().ifPresent(radar -> {
                double newDistance;
                Vec3 selectedNew;
                Vec3 entityPos;
                double bestDistance = 0.1f * range;
                for (RadarTrack radarTrack : radar.getEntityPositions()) {
                    entityPos = radarTrack.position();
                    entityPos = entityPos.m_82542_(1.0, 0.0, 1.0);
                    selectedNew = selected.m_82542_(1.0, 0.0, 1.0);
                    newDistance = entityPos.m_82554_(selectedNew);
                    if (monitor.hoveredEntity != null && monitor.hoveredEntity.equals(radarTrack.entityId()) && newDistance > bestDistance) {
                        monitor.hoveredEntity = null;
                    }
                    if (!(newDistance < bestDistance)) continue;
                    bestDistance = newDistance;
                    monitor.hoveredEntity = radarTrack.entityId();
                }
                for (VSRadarTracks vSRadarTracks : radar.getVS2Positions()) {
                    entityPos = vSRadarTracks.position();
                    entityPos = entityPos.m_82542_(1.0, 0.0, 1.0);
                    selectedNew = selected.m_82542_(1.0, 0.0, 1.0);
                    newDistance = entityPos.m_82554_(selectedNew);
                    if (monitor.hoveredEntity != null && monitor.hoveredEntity.equals(vSRadarTracks.id()) && newDistance > bestDistance) {
                        monitor.hoveredEntity = null;
                    }
                    if (!(newDistance < bestDistance)) continue;
                    bestDistance = newDistance;
                    monitor.hoveredEntity = vSRadarTracks.id();
                }
            });
            monitor.notifyUpdate();
        }
    }
}

