/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.controller.yaw;

import com.happysg.radar.block.controller.yaw.AutoYawControllerBlockEntity;
import com.happysg.radar.block.monitor.MonitorBlockEntity;
import com.happysg.radar.block.radar.link.RadarLinkBlockEntity;
import com.happysg.radar.block.radar.link.RadarLinkContext;
import com.happysg.radar.block.radar.link.RadarSource;
import com.happysg.radar.block.radar.link.RadarTarget;
import com.happysg.radar.block.radar.link.screens.AbstractRadarLinkScreen;
import com.happysg.radar.block.radar.link.screens.TargetingConfig;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class YawLinkBehavior
extends RadarSource {
    @Override
    public void transferData(RadarLinkContext context, @NotNull RadarTarget activeTarget) {
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (!(blockEntity instanceof AutoYawControllerBlockEntity)) {
            return;
        }
        AutoYawControllerBlockEntity controller = (AutoYawControllerBlockEntity)blockEntity;
        if (!(context.getTargetBlockEntity() instanceof MonitorBlockEntity)) {
            return;
        }
        MonitorBlockEntity monitor = ((MonitorBlockEntity)context.getTargetBlockEntity()).getController();
        if (monitor == null) {
            return;
        }
        TargetingConfig targetingConfig = TargetingConfig.fromTag(context.sourceConfig().m_128469_("targeting"));
        Vec3 targetPos = monitor.getTargetPos(targetingConfig);
        controller.setTarget(targetPos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected AbstractRadarLinkScreen getScreen(RadarLinkBlockEntity be) {
        return null;
    }
}

