/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.controller.pitch;

import com.happysg.radar.block.controller.pitch.AutoPitchControllerBlockEntity;
import com.happysg.radar.block.monitor.MonitorBlockEntity;
import com.happysg.radar.block.radar.link.RadarLinkBlockEntity;
import com.happysg.radar.block.radar.link.RadarLinkContext;
import com.happysg.radar.block.radar.link.RadarSource;
import com.happysg.radar.block.radar.link.RadarTarget;
import com.happysg.radar.block.radar.link.screens.AbstractRadarLinkScreen;
import com.happysg.radar.block.radar.link.screens.RadarTargetScreen;
import com.happysg.radar.block.radar.link.screens.TargetingConfig;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class PitchLinkBehavior
extends RadarSource {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected AbstractRadarLinkScreen getScreen(RadarLinkBlockEntity be) {
        return new RadarTargetScreen(be);
    }

    @Override
    protected void transferData(@NotNull RadarLinkContext context, @NotNull RadarTarget activeTarget) {
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (!(blockEntity instanceof AutoPitchControllerBlockEntity)) {
            return;
        }
        AutoPitchControllerBlockEntity controller = (AutoPitchControllerBlockEntity)blockEntity;
        if (!(context.getTargetBlockEntity() instanceof MonitorBlockEntity)) {
            return;
        }
        MonitorBlockEntity monitor = ((MonitorBlockEntity)context.getTargetBlockEntity()).getController();
        if (monitor == null) {
            return;
        }
        TargetingConfig targetingConfig = TargetingConfig.fromTag(context.sourceConfig().m_128469_("targeting"));
        Vec3 targetPos = monitor.getTargetPos(targetingConfig);
        controller.setTarget(targetPos);
        controller.setTargetingConfig(targetingConfig);
    }
}

