/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.controller.pitch;

import com.happysg.radar.block.controller.pitch.AutoPitchControllerBlock;
import com.happysg.radar.block.controller.yaw.AutoYawControllerBlockEntity;
import com.happysg.radar.block.radar.link.screens.TargetingConfig;
import com.happysg.radar.compat.Mods;
import com.happysg.radar.compat.cbc.CannonTargeting;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;

public class AutoPitchControllerBlockEntity
extends KineticBlockEntity {
    private static final double TOLERANCE = 0.1;
    private double targetAngle;
    private boolean isRunning;
    private boolean artillery = false;
    public int chargeCount;
    TargetingConfig targetingConfig = TargetingConfig.DEFAULT;

    public AutoPitchControllerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void tick() {
        super.tick();
        if (Mods.CREATEBIGCANNONS.isLoaded()) {
            this.tryRotateCannon();
        }
    }

    private void tryRotateCannon() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        BlockPos cannonMountPos = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_(AutoPitchControllerBlock.HORIZONTAL_FACING));
        BlockEntity blockEntity = this.f_58857_.m_7702_(cannonMountPos);
        if (!(blockEntity instanceof CannonMountBlockEntity)) {
            return;
        }
        CannonMountBlockEntity mount = (CannonMountBlockEntity)blockEntity;
        if (!this.isRunning) {
            this.stopFireCannon(mount);
            return;
        }
        PitchOrientedContraptionEntity contraption = mount.getContraption();
        if (contraption == null) {
            return;
        }
        Contraption contraption2 = contraption.getContraption();
        if (!(contraption2 instanceof AbstractMountedCannonContraption)) {
            return;
        }
        AbstractMountedCannonContraption cannonContraption = (AbstractMountedCannonContraption)contraption2;
        double currentPitch = contraption.pitch;
        int invert = -cannonContraption.initialOrientation().m_122429_() + cannonContraption.initialOrientation().m_122431_();
        if (this.correctPitch(currentPitch *= (double)(-invert)) && this.correctYaw() && this.targetingConfig.autoFire()) {
            this.tryFireCannon(mount);
        } else {
            this.stopFireCannon(mount);
        }
        double pitchDifference = this.targetAngle - currentPitch;
        double speedFactor = (double)Math.abs(this.getSpeed()) / 32.0;
        currentPitch = Math.abs(pitchDifference) > 0.1 ? (Math.abs(pitchDifference) > speedFactor ? (currentPitch += Math.signum(pitchDifference) * speedFactor) : this.targetAngle) : this.targetAngle;
        mount.setPitch((float)currentPitch);
        mount.notifyUpdate();
    }

    private boolean correctPitch(double currentPitch) {
        return Math.abs(this.targetAngle - currentPitch) < 0.1;
    }

    private boolean correctYaw() {
        BlockPos cannonMountPos = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_(AutoPitchControllerBlock.HORIZONTAL_FACING));
        BlockEntity blockEntity = this.f_58857_.m_7702_(cannonMountPos.m_7495_());
        if (!(blockEntity instanceof AutoYawControllerBlockEntity)) {
            return false;
        }
        AutoYawControllerBlockEntity yawController = (AutoYawControllerBlockEntity)blockEntity;
        return yawController.atTargetYaw();
    }

    private void stopFireCannon(CannonMountBlockEntity mount) {
        mount.onRedstoneUpdate(true, true, false, true, 0);
    }

    private void tryFireCannon(CannonMountBlockEntity mount) {
        mount.onRedstoneUpdate(true, true, true, false, 15);
    }

    public void setTargetAngle(float targetAngle) {
        this.targetAngle = targetAngle;
        this.notifyUpdate();
    }

    public double getTargetAngle() {
        return this.targetAngle;
    }

    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.targetAngle = compound.m_128459_("TargetAngle");
        this.isRunning = compound.m_128471_("IsRunning");
        this.targetingConfig = TargetingConfig.fromTag(compound.m_128469_("TargetingConfig"));
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128347_("TargetAngle", this.targetAngle);
        compound.m_128379_("IsRunning", this.isRunning);
        compound.m_128365_("TargetingConfig", (Tag)this.targetingConfig.toTag());
    }

    public void setTarget(Vec3 targetPos) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (targetPos == null) {
            this.isRunning = false;
            return;
        }
        this.isRunning = true;
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_(AutoPitchControllerBlock.HORIZONTAL_FACING)));
        if (blockEntity instanceof CannonMountBlockEntity) {
            CannonMountBlockEntity mount = (CannonMountBlockEntity)blockEntity;
            List<Double> angles = CannonTargeting.calculatePitch(mount, targetPos, (ServerLevel)this.f_58857_);
            if (angles == null || angles.isEmpty()) {
                this.isRunning = false;
                return;
            }
            ArrayList<Double> usableAngles = new ArrayList<Double>();
            for (double angle : angles) {
                if (mount.getContraption() == null) break;
                if (!(angle < (double)mount.getContraption().maximumElevation()) || !(angle > (double)(-mount.getContraption().maximumDepression()))) continue;
                usableAngles.add(angle);
            }
            if (this.artillery && usableAngles.size() == 2) {
                this.targetAngle = angles.get(1);
            } else if (!usableAngles.isEmpty()) {
                this.targetAngle = (Double)usableAngles.get(0);
            }
        }
        this.notifyUpdate();
    }

    public void setTargetingConfig(TargetingConfig targetingConfig) {
        this.targetingConfig = targetingConfig;
        this.notifyUpdate();
    }
}

