/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar;

import com.happysg.radar.block.monitor.MonitorInputHandler;
import com.happysg.radar.block.radar.link.RadarLinkBlockItem;
import com.happysg.radar.config.RadarConfig;
import com.happysg.radar.networking.ModMessages;
import com.happysg.radar.registry.AllRadarBehaviors;
import com.happysg.radar.registry.ModBlockEntityTypes;
import com.happysg.radar.registry.ModBlocks;
import com.happysg.radar.registry.ModContraptionTypes;
import com.happysg.radar.registry.ModCreativeTabs;
import com.happysg.radar.registry.ModDisplayBehaviors;
import com.happysg.radar.registry.ModItems;
import com.happysg.radar.registry.ModLang;
import com.happysg.radar.registry.ModPartials;
import com.happysg.radar.registry.ModPonderIndex;
import com.happysg.radar.registry.ModPonderTags;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Mod(value="create_radar")
public class CreateRadar {
    public static final String MODID = "create_radar";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"create_radar");

    public CreateRadar() {
        CreateRadar.getLogger().info("Initializing Create Radar!");
        ModLoadingContext context = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRATE.registerEventListeners(modEventBus);
        ModItems.register();
        ModBlocks.register();
        ModBlockEntityTypes.register();
        ModCreativeTabs.register(modEventBus);
        ModLang.register();
        ModPartials.init();
        RadarConfig.register(context);
        ModContraptionTypes.register();
        modEventBus.addListener(CreateRadar::init);
        modEventBus.addListener(CreateRadar::clientInit);
        modEventBus.addListener(CreateRadar::onLoadComplete);
        MinecraftForge.EVENT_BUS.addListener(MonitorInputHandler::monitorPlayerHovering);
        MinecraftForge.EVENT_BUS.addListener(CreateRadar::clientTick);
    }

    private static void clientTick(TickEvent.ClientTickEvent event) {
        RadarLinkBlockItem.clientTick();
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static String toHumanReadable(String key) {
        String s = key.replace("_", " ");
        s = Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)s)).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        return StringUtils.normalizeSpace((String)s);
    }

    public static void clientInit(FMLClientSetupEvent event) {
        ModPonderIndex.register();
        ModPonderTags.register();
    }

    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        ModContainer container = (ModContainer)ModList.get().getModContainerById(MODID).orElseThrow(() -> new IllegalStateException("Radar mod container missing on LoadComplete"));
        container.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(RadarConfig::createConfigScreen));
    }

    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(ModMessages::register);
        ModDisplayBehaviors.register();
        AllRadarBehaviors.registerDefaults();
    }
}

