/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.element.BoxElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.element.AnimatedOverlayElement;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.Color;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class TextWindowElement
extends AnimatedOverlayElement {
    Supplier<String> textGetter = () -> "(?) No text was provided";
    String bakedText;
    int y;
    Vec3 vec;
    boolean nearScene = false;
    int color = PonderPalette.WHITE.getColor();

    @Override
    protected void render(PonderScene scene, PonderUI screen, GuiGraphics graphics, float partialTicks, float fade) {
        if (this.bakedText == null) {
            this.bakedText = this.textGetter.get();
        }
        if (fade < 0.0625f) {
            return;
        }
        PonderScene.SceneTransform transform = scene.getTransform();
        Vec2 sceneToScreen = this.vec != null ? transform.sceneToScreen(this.vec, partialTicks) : new Vec2((float)(screen.f_96543_ / 2), (float)((screen.f_96544_ - 200) / 2 + this.y - 8));
        boolean settled = transform.xRotation.settled() && transform.yRotation.settled();
        float pY = settled ? (float)((int)sceneToScreen.f_82471_) : sceneToScreen.f_82471_;
        float yDiff = ((float)screen.f_96544_ / 2.0f - sceneToScreen.f_82471_ - 10.0f) / 100.0f;
        float targetX = (float)screen.f_96543_ * Mth.m_14179_((float)(yDiff * yDiff), (float)0.75f, (float)0.625f);
        if (this.nearScene) {
            targetX = Math.min(targetX, sceneToScreen.f_82470_ + 50.0f);
        }
        if (settled) {
            targetX = (int)targetX;
        }
        int textWidth = (int)Math.min((float)screen.f_96543_ - targetX, 180.0f);
        List lines = screen.getFontRenderer().m_92865_().m_92432_(this.bakedText, textWidth, Style.f_131099_);
        int boxWidth = 0;
        for (FormattedText line : lines) {
            boxWidth = Math.max(boxWidth, screen.getFontRenderer().m_92852_(line));
        }
        int boxHeight = screen.getFontRenderer().m_92920_(this.bakedText, boxWidth);
        PoseStack ms = graphics.m_280168_();
        ms.m_85836_();
        ms.m_252880_(0.0f, pY, 400.0f);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.TEXT_WINDOW_BORDER))).at(targetX - 10.0f, 3.0f, 100.0f)).withBounds(boxWidth, boxHeight - 1)).render(graphics);
        int brighterColor = Color.mixColors(this.color, -35, 0.5f);
        brighterColor = 0xFFFFFF & brighterColor | 0xFF000000;
        if (this.vec != null) {
            ms.m_85836_();
            ms.m_252880_(sceneToScreen.f_82470_, 0.0f, 0.0f);
            double lineTarget = (targetX - sceneToScreen.f_82470_) * fade;
            ms.m_85841_((float)lineTarget, 1.0f, 1.0f);
            graphics.m_280120_(0, 0, 1, 1, -100, brighterColor, brighterColor);
            graphics.m_280120_(0, 1, 1, 2, -100, -11974327, -13027015);
            ms.m_85849_();
        }
        ms.m_252880_(0.0f, 0.0f, 400.0f);
        for (int i = 0; i < lines.size(); ++i) {
            graphics.drawString(screen.getFontRenderer(), ((FormattedText)lines.get(i)).getString(), targetX - 10.0f, (float)(3 + 9 * i), new Color(brighterColor).scaleAlpha(fade).getRGB(), false);
        }
        ms.m_85849_();
    }

    public int getColor() {
        return this.color;
    }

    public class Builder {
        private PonderScene scene;

        public Builder(PonderScene scene) {
            this.scene = scene;
        }

        public Builder colored(PonderPalette color) {
            TextWindowElement.this.color = color.getColor();
            return this;
        }

        public Builder pointAt(Vec3 vec) {
            TextWindowElement.this.vec = vec;
            return this;
        }

        public Builder independent(int y) {
            TextWindowElement.this.y = y;
            return this;
        }

        public Builder independent() {
            return this.independent(0);
        }

        public Builder text(String defaultText) {
            TextWindowElement.this.textGetter = this.scene.registerText(defaultText);
            return this;
        }

        public Builder sharedText(ResourceLocation key) {
            TextWindowElement.this.textGetter = () -> PonderLocalization.getShared(key);
            return this;
        }

        public Builder sharedText(String key) {
            return this.sharedText(new ResourceLocation(this.scene.getNamespace(), key));
        }

        public Builder placeNearTarget() {
            TextWindowElement.this.nearScene = true;
            return this;
        }

        public Builder attachKeyFrame() {
            this.scene.builder().addLazyKeyframe();
            return this;
        }
    }
}

