/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.corelib.client.obj;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import de.maxhenkel.corpse.corelib.client.obj.OBJModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class OBJLoader {
    private static Map<ResourceLocation, OBJModel.OBJModelData> modelCache = new HashMap<ResourceLocation, OBJModel.OBJModelData>();

    public static OBJModel.OBJModelData load(ResourceLocation model) {
        try {
            return OBJLoader.loadInternal(model);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static OBJModel.OBJModelData loadInternal(ResourceLocation model) throws IOException {
        String[] line;
        if (modelCache.containsKey(model)) {
            return modelCache.get(model);
        }
        Optional optionalResource = Minecraft.m_91087_().m_91098_().m_213713_(model);
        if (optionalResource.isEmpty()) {
            throw new IOException("Failed to load model '%s'".formatted(model));
        }
        LineReader reader = new LineReader((Resource)optionalResource.get());
        ArrayList positions = Lists.newArrayList();
        ArrayList texCoords = Lists.newArrayList();
        ArrayList normals = Lists.newArrayList();
        ArrayList faces = Lists.newArrayList();
        while ((line = reader.readAndSplitLine(true)) != null) {
            switch (line[0]) {
                case "v": {
                    positions.add(OBJLoader.parseVector4To3(line));
                    break;
                }
                case "vt": {
                    Vec2 vec2f = OBJLoader.parseVector2(line);
                    texCoords.add(new Vec2(vec2f.f_82470_, 1.0f - vec2f.f_82471_));
                    break;
                }
                case "vn": {
                    normals.add(OBJLoader.parseVector3(line));
                    break;
                }
                case "f": {
                    int[][] vertices = new int[line.length - 1][];
                    for (int i = 0; i < vertices.length; ++i) {
                        String vertexData = line[i + 1];
                        String[] vertexParts = vertexData.split("/");
                        int[] vertex = Arrays.stream(vertexParts).mapToInt(num -> Strings.isNullOrEmpty((String)num) ? 0 : Integer.parseInt(num)).toArray();
                        vertex[0] = vertex[0] < 0 ? positions.size() + vertex[0] : vertex[0] - 1;
                        if (vertex.length > 1) {
                            vertex[1] = vertex[1] < 0 ? texCoords.size() + vertex[1] : vertex[1] - 1;
                            if (vertex.length > 2) {
                                vertex[2] = vertex[2] < 0 ? normals.size() + vertex[2] : vertex[2] - 1;
                            }
                        }
                        vertices[i] = vertex;
                    }
                    faces.add(vertices);
                }
            }
        }
        OBJModel.OBJModelData obj = new OBJModel.OBJModelData(positions, texCoords, normals, faces);
        modelCache.put(model, obj);
        return obj;
    }

    private static Vector3f parseVector4To3(String[] line) {
        Vector4f vec4 = OBJLoader.parseVector4(line);
        return new Vector3f(vec4.x() / vec4.w(), vec4.y() / vec4.w(), vec4.z() / vec4.w());
    }

    private static Vec2 parseVector2(String[] line) {
        return switch (line.length) {
            case 1 -> new Vec2(0.0f, 0.0f);
            case 2 -> new Vec2(Float.parseFloat(line[1]), 0.0f);
            default -> new Vec2(Float.parseFloat(line[1]), Float.parseFloat(line[2]));
        };
    }

    private static Vector3f parseVector3(String[] line) {
        return switch (line.length) {
            case 1 -> new Vector3f(0.0f, 0.0f, 0.0f);
            case 2 -> new Vector3f(Float.parseFloat(line[1]), 0.0f, 0.0f);
            case 3 -> new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f);
            default -> new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]));
        };
    }

    static Vector4f parseVector4(String[] line) {
        return switch (line.length) {
            case 1 -> new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            case 2 -> new Vector4f(Float.parseFloat(line[1]), 0.0f, 0.0f, 1.0f);
            case 3 -> new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f, 1.0f);
            case 4 -> new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), 1.0f);
            default -> new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), Float.parseFloat(line[4]));
        };
    }

    private static class LineReader
    implements AutoCloseable {
        private InputStreamReader lineStream;
        private BufferedReader lineReader;

        public LineReader(Resource resource) throws IOException {
            this.lineStream = new InputStreamReader(resource.m_215507_(), Charsets.UTF_8);
            this.lineReader = new BufferedReader(this.lineStream);
        }

        @Nullable
        public String[] readAndSplitLine(boolean ignoreEmptyLines) throws IOException {
            do {
                String currentLine;
                if ((currentLine = this.lineReader.readLine()) == null) {
                    return null;
                }
                ArrayList lineParts = new ArrayList();
                if (currentLine.startsWith("#")) {
                    currentLine = "";
                }
                if (currentLine.length() > 0) {
                    boolean hasContinuation;
                    do {
                        String tmp = (hasContinuation = currentLine.endsWith("\\")) ? currentLine.substring(0, currentLine.length() - 1) : currentLine;
                        Arrays.stream(tmp.split("[\t ]+")).filter(s -> !Strings.isNullOrEmpty((String)s)).forEach(lineParts::add);
                    } while ((!hasContinuation || (currentLine = this.lineReader.readLine()) != null && currentLine.length() != 0 && !currentLine.startsWith("#")) && hasContinuation);
                }
                if (lineParts.size() <= 0) continue;
                return lineParts.toArray(new String[0]);
            } while (ignoreEmptyLines);
            return new String[0];
        }

        @Override
        public void close() throws Exception {
            this.lineReader.close();
            this.lineStream.close();
        }
    }
}

