/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.utility;

import com.copycatsplus.copycats.foundation.copycat.CopycatExternalContext;
import com.copycatsplus.copycats.foundation.copycat.model.ScaledBlockAndTintGetter;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.mixin.copycat.VoxelShapeAccessor;
import com.copycatsplus.copycats.utility.MathUtils;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.SliceShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockFaceUtils {
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> cacheMap = new Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>(2048, 0.25f){

            protected void rehash(int i) {
            }
        };
        cacheMap.defaultReturnValue((byte)127);
        return cacheMap;
    });
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>> MATCH_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> cacheMap = new Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>(2048, 0.25f){

            protected void rehash(int i) {
            }
        };
        cacheMap.defaultReturnValue((byte)127);
        return cacheMap;
    });

    private static boolean processBlockFace(BlockGetter level, BlockState fromState, BlockPos fromPos, BlockState toState, BlockPos toPos, Direction fromFace, BiFunction<VoxelShape, VoxelShape, Boolean> operation, Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> cache) {
        VoxelShape fromShape = null;
        Vec3i scale = new Vec3i(1, 1, 1);
        Vec3i inner = new Vec3i(0, 0, 0);
        BlockPos truePos = fromPos;
        if (level instanceof ScaledBlockAndTintGetter) {
            IMultiStateCopycatBlock copycatBlock;
            ScaledBlockAndTintGetter scaledWorld = (ScaledBlockAndTintGetter)level;
            scale = scaledWorld.getScale();
            truePos = scaledWorld.getTruePos(fromPos);
            Block block = fromState.m_60734_();
            if (block instanceof IMultiStateCopycatBlock && (copycatBlock = (IMultiStateCopycatBlock)block).vectorScale(fromState).equals((Object)scaledWorld.getScale())) {
                String property = scaledWorld.getPropertyForRender(fromState, fromPos);
                if (!copycatBlock.partExists(fromState, property)) {
                    return false;
                }
                inner = copycatBlock.getVectorFromProperty(fromState, property);
                fromShape = BlockFaceUtils.getPartialFaceShape(fromState.m_60768_((BlockGetter)scaledWorld.getWrapped(), truePos), fromFace, (double)inner.m_123341_() / (double)scale.m_123341_(), (double)inner.m_123342_() / (double)scale.m_123342_(), (double)inner.m_123343_() / (double)scale.m_123343_(), 1.0 / (double)scale.m_123341_(), 1.0 / (double)scale.m_123342_(), 1.0 / (double)scale.m_123343_());
            }
        }
        if (fromShape == null) {
            fromShape = fromState.m_60655_(level, fromPos, fromFace);
        }
        if (fromShape.m_83281_()) {
            return false;
        }
        VoxelShape toShape = null;
        List<Vec3i> potentialParts = null;
        Block block = toState.m_60734_();
        if (block instanceof IMultiStateCopycatBlock) {
            IMultiStateCopycatBlock copycatBlock = (IMultiStateCopycatBlock)block;
            Vec3i toScale = copycatBlock.vectorScale(toState);
            Direction.Axis connectingAxis = fromFace.m_122434_();
            BlockGetter world = level;
            BlockPos toTruePos = toPos;
            if (level instanceof ScaledBlockAndTintGetter) {
                ScaledBlockAndTintGetter scaledWorld = (ScaledBlockAndTintGetter)level;
                world = scaledWorld.getWrapped();
                toTruePos = scaledWorld.getTruePos(toPos);
                if (toTruePos.equals((Object)truePos)) {
                    String toProperty = scaledWorld.getPropertyForRender(toState, toPos);
                    potentialParts = List.of(copycatBlock.getVectorFromProperty(toState, toProperty));
                }
            }
            if (potentialParts == null) {
                potentialParts = MathUtils.replaceAxis(scale, connectingAxis, 0).equals((Object)MathUtils.replaceAxis(toScale, connectingAxis, 0)) ? List.of(MathUtils.replaceAxis(inner, connectingAxis, fromFace.m_122421_() == Direction.AxisDirection.POSITIVE ? 0 : toScale.m_123304_(connectingAxis) - 1)) : BlockFaceUtils.getOverlappingParts(toScale, connectingAxis, fromFace.m_122421_() == Direction.AxisDirection.POSITIVE ? 0 : toScale.m_123304_(connectingAxis) - 1);
            }
            VoxelShape baseShape = toState.m_60768_(world, toTruePos);
            for (Vec3i part : potentialParts) {
                toShape = BlockFaceUtils.getPartialFaceShape(baseShape, fromFace.m_122424_(), (double)part.m_123341_() / (double)toScale.m_123341_(), (double)part.m_123342_() / (double)toScale.m_123342_(), (double)part.m_123343_() / (double)toScale.m_123343_(), 1.0 / (double)toScale.m_123341_(), 1.0 / (double)toScale.m_123342_(), 1.0 / (double)toScale.m_123343_());
                if (!operation.apply(fromShape, toShape).booleanValue()) continue;
                String property = CopycatExternalContext.getPropertyForAppearance();
                if (property == null) {
                    property = copycatBlock.defaultProperty();
                }
                CopycatExternalContext.setPropertyForAppearance(copycatBlock.getPropertyFromRender(property, toState, world, part, toTruePos));
                return true;
            }
        }
        if (toShape == null) {
            toShape = toState.m_60655_(level, toPos, fromFace.m_122424_());
        }
        CopycatExternalContext.setPropertyForAppearance(null);
        return operation.apply(fromShape, toShape);
    }

    public static boolean canOcclude(BlockGetter level, BlockState occludedState, BlockPos occludedPos, BlockState occludingState, BlockPos occludingPos, Direction occludedFace) {
        return BlockFaceUtils.processBlockFace(level, occludedState, occludedPos, occludingState, occludingPos, occludedFace, (occluded, occluding) -> !Shapes.m_83157_((VoxelShape)occluded, (VoxelShape)occluding, (BooleanOp)BooleanOp.f_82685_), OCCLUSION_CACHE.get());
    }

    public static boolean faceMatch(BlockGetter level, BlockState fromState, BlockPos fromPos, BlockState toState, BlockPos toPos, Direction fromFace) {
        return BlockFaceUtils.processBlockFace(level, fromState, fromPos, toState, toPos, fromFace, (from, to) -> !Shapes.m_83157_((VoxelShape)from, (VoxelShape)to, (BooleanOp)BooleanOp.f_82687_), MATCH_CACHE.get());
    }

    public static VoxelShape getPartialFaceShape(VoxelShape voxelShape, Direction direction, double startX, double startY, double startZ, double sizeX, double sizeY, double sizeZ) {
        int i;
        Direction.Axis axis = direction.m_122434_();
        double endX = startX + sizeX;
        double endY = startY + sizeY;
        double endZ = startZ + sizeZ;
        VoxelShape bounds = Shapes.m_83048_((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ);
        voxelShape = Shapes.m_83148_((VoxelShape)voxelShape, (VoxelShape)bounds, (BooleanOp)BooleanOp.f_82689_);
        int axisSize = ((VoxelShapeAccessor)voxelShape).copycats$getShape().m_82850_(axis);
        boolean isEmpty = false;
        if (direction.m_122421_() == Direction.AxisDirection.POSITIVE) {
            double d = voxelShape.m_83297_(axis);
            isEmpty = DoubleMath.fuzzyCompare((double)d, (double)(switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> endX;
                case Direction.Axis.Y -> endY;
                case Direction.Axis.Z -> endZ;
            }), (double)1.0E-7) < 0;
            i = Mth.m_14107_((double)Mth.m_14008_((double)((double)axisSize * axis.m_6150_(endX, endY, endZ)), (double)-1.0, (double)axisSize)) - 1;
        } else {
            double d = voxelShape.m_83288_(axis);
            isEmpty = DoubleMath.fuzzyCompare((double)d, (double)(switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> startX;
                case Direction.Axis.Y -> startY;
                case Direction.Axis.Z -> startZ;
            }), (double)1.0E-7) > 0;
            i = Mth.m_14107_((double)Mth.m_14008_((double)((double)axisSize * axis.m_6150_(startX, startY, startZ)), (double)-1.0, (double)axisSize));
        }
        if (isEmpty) {
            return Shapes.m_83040_();
        }
        return new SliceShape(voxelShape, axis, i);
    }

    private static List<Vec3i> getOverlappingParts(Vec3i toScale, Direction.Axis connectingAxis, int connectingPart) {
        Direction.Axis axis1 = switch (connectingAxis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> Direction.Axis.Y;
            case Direction.Axis.Y -> Direction.Axis.Z;
            case Direction.Axis.Z -> Direction.Axis.X;
        };
        Direction.Axis axis2 = switch (connectingAxis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> Direction.Axis.Z;
            case Direction.Axis.Y -> Direction.Axis.X;
            case Direction.Axis.Z -> Direction.Axis.Y;
        };
        ArrayList<Vec3i> parts = new ArrayList<Vec3i>(4);
        for (int i = 0; i < toScale.m_123304_(axis1); ++i) {
            for (int j = 0; j < toScale.m_123304_(axis2); ++j) {
                parts.add(MathUtils.replaceAxis(MathUtils.replaceAxis(new Vec3i(connectingPart, connectingPart, connectingPart), axis1, i), axis2, j));
            }
        }
        return parts;
    }
}

