/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.half_panel;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.foundation.copycat.CCWaterloggedCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.utility.BlockUtils;
import com.copycatsplus.copycats.utility.InteractionUtils;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.foundation.placement.PoleHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatHalfPanelBlock
extends CCWaterloggedCopycatBlock
implements IStateType {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final DirectionProperty OFFSET = DirectionProperty.m_61546_((String)"offset", (Predicate)Direction.Plane.HORIZONTAL);
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public CopycatHalfPanelBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OFFSET, (Comparable)Direction.NORTH));
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult ray) {
        return InteractionUtils.sequential(() -> InteractionUtils.usePlacementHelper(placementHelperId, state, world, pos, player, hand, ray), () -> super.m_6227_(state, world, pos, player, hand, ray));
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        double offset1;
        BlockState stateForPlacement = super.m_5573_(context);
        if (stateForPlacement == null) {
            return null;
        }
        Direction facing = context.m_43719_().m_122424_();
        double offset2 = switch (facing.m_122434_()) {
            case Direction.Axis.X -> {
                offset1 = context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_();
                yield context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_();
            }
            case Direction.Axis.Y -> {
                offset1 = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_();
                yield context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_();
            }
            case Direction.Axis.Z -> {
                offset1 = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_();
                yield context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_();
            }
            default -> {
                offset1 = 0.0;
                yield 0.0;
            }
        };
        Direction offset = Math.abs(offset1 - 0.5) > Math.abs(offset2 - 0.5) ? Direction.m_122387_((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)(offset1 > 0.5 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE)) : Direction.m_122387_((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)(offset2 > 0.5 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
        return (BlockState)((BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)OFFSET, (Comparable)offset);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{FACING, OFFSET}));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return CCShapes.HALF_PANEL.get(pState.m_61143_((Property)FACING)).get(pState.m_61143_((Property)OFFSET)).toShape();
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction offset = (Direction)state.m_61143_((Property)OFFSET);
        BlockPos offsetNormal = transform.applyWithoutOffset(new BlockPos(CopycatHalfPanelBlock.getOffsetFacing(facing, offset).m_122436_()));
        Direction newFacing = BlockUtils.transformFacing(transform, facing);
        Vec3i facingNormal = newFacing.m_122436_();
        if (offsetNormal.m_123342_() != 0) {
            offsetNormal = offsetNormal.m_123341_() == 0 && facingNormal.m_123341_() != 0 ? new Vec3i(offsetNormal.m_123342_(), offsetNormal.m_123341_(), offsetNormal.m_123343_()) : new Vec3i(offsetNormal.m_123341_(), offsetNormal.m_123343_(), offsetNormal.m_123342_());
        }
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)newFacing)).m_61124_((Property)OFFSET, (Comparable)Objects.requireNonNull(Direction.m_122378_((int)offsetNormal.m_123341_(), (int)offsetNormal.m_123342_(), (int)offsetNormal.m_123343_())));
    }

    public static Direction getOffsetFacing(Direction facing, Direction offset) {
        if (offset.m_122434_().m_122478_()) {
            throw new IllegalArgumentException("offset must be a horizontal direction.");
        }
        Vec3i facingNormal = facing.m_122436_();
        Vec3i offsetNormal = offset.m_122436_();
        if (facingNormal.m_123341_() != 0 && offsetNormal.m_123341_() != 0) {
            offsetNormal = new Vec3i(offsetNormal.m_123342_(), offsetNormal.m_123341_(), offsetNormal.m_123343_());
        }
        if (facingNormal.m_123343_() != 0 && offsetNormal.m_123343_() != 0) {
            offsetNormal = new Vec3i(offsetNormal.m_123341_(), offsetNormal.m_123343_(), offsetNormal.m_123342_());
        }
        return Objects.requireNonNull(Direction.m_122378_((int)offsetNormal.m_123341_(), (int)offsetNormal.m_123342_(), (int)offsetNormal.m_123343_()));
    }

    public static Direction.Axis getOffsetAxis(Direction facing, Direction offset) {
        Direction offsetFacing = CopycatHalfPanelBlock.getOffsetFacing(facing, offset);
        if (facing.m_122434_().m_122478_()) {
            return offsetFacing.m_122427_().m_122434_();
        }
        if (offsetFacing.m_122434_().m_122478_()) {
            return facing.m_122427_().m_122434_();
        }
        return Direction.Axis.Y;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction> {
        private PlacementHelper() {
            super(arg_0 -> CCBlocks.COPYCAT_HALF_PANEL.has(arg_0), state -> CopycatHalfPanelBlock.getOffsetAxis((Direction)state.m_61143_((Property)FACING), (Direction)state.m_61143_((Property)OFFSET)), (Property)FACING);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof CopycatHalfPanelBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistance((BlockPos)pos, (Vec3)ray.m_82450_(), dir -> dir.m_122434_() == this.axisFunction.apply(state));
            for (Direction dir2 : directions) {
                BlockPos newPos;
                BlockState newState;
                int poles;
                Object reach;
                int range = (Integer)AllConfigs.server().equipment.placementAssistRange.get();
                if (player != null && (reach = null) != null && reach.m_22109_(ExtendoGripItem.singleRangeAttributeModifier)) {
                    range += 4;
                }
                if ((poles = this.attachedPoles(world, pos, dir2)) >= range || !(newState = world.m_8055_(newPos = pos.m_5484_(dir2, poles + 1))).m_247087_()) continue;
                return PlacementOffset.success((Vec3i)newPos, bState -> (BlockState)((BlockState)bState.m_61124_(this.property, (Comparable)((Direction)state.m_61143_(this.property)))).m_61124_((Property)OFFSET, (Comparable)((Direction)state.m_61143_((Property)OFFSET))));
            }
            return PlacementOffset.fail();
        }
    }
}

