/*
 * Decompiled with CFR 0.152.
 */
package net.talesstudio.chunkoptimizer.server;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chunkoptimizer", value={Dist.DEDICATED_SERVER})
public class AsyncStructureLoader {
    private static final ExecutorService structureExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

    public static void loadStructureAsync(ServerLevel serverWorld, BlockPos startPos, List<BlockPos> structureParts) {
        CompletableFuture.runAsync(() -> {
            for (BlockPos part : structureParts) {
                AsyncStructureLoader.loadStructurePart(serverWorld, startPos.m_121955_((Vec3i)part));
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }, structureExecutor);
    }

    private static void loadStructurePart(ServerLevel serverWorld, BlockPos pos) {
        serverWorld.m_7731_(pos, Blocks.f_50069_.m_49966_(), 3);
    }

    public static void shutdown() {
        structureExecutor.shutdown();
    }
}

