/*
 * Decompiled with CFR 0.152.
 */
package net.talesstudio.chunkoptimizer.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chunkoptimizer", value={Dist.DEDICATED_SERVER})
public class AsyncChunkManager {
    private static Executors Executors;
    private static final ExecutorService executorService;

    public static void preloadChunkAsync(ServerLevel serverWorld, int chunkX, int chunkZ) {
        CompletableFuture.supplyAsync(() -> serverWorld.m_7726_().m_62227_(chunkX, chunkZ, true), executorService).thenAccept(chunk -> {
            if (chunk != null) {
                AsyncChunkManager.postLoadOperations(serverWorld, chunkX, chunkZ);
            }
        });
    }

    private static void postLoadOperations(ServerLevel serverWorld, int chunkX, int chunkZ) {
        LevelChunk chunk = serverWorld.m_6325_(chunkX, chunkZ);
        if (chunk != null) {
            // empty if block
        }
    }

    public static void shutdown() {
        executorService.shutdown();
    }

    static {
        executorService = java.util.concurrent.Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }
}

