/*
 * Decompiled with CFR 0.152.
 */
package net.talesstudio.chunkoptimizer.client;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.talesstudio.chunkoptimizer.client.AsyncTextureLoader;

@Mod.EventBusSubscriber(modid="chunkoptimizer", value={Dist.CLIENT})
public class ChunkOptimizerClient {
    public static void loadChunkTexturesAsync(LevelChunk chunk) {
        if (chunk != null) {
            Set<ResourceLocation> textures = ChunkOptimizerClient.getChunkTextures(chunk);
            for (ResourceLocation texture : textures) {
                AsyncTextureLoader.loadTextureAsync(texture);
            }
        }
    }

    private static Set<ResourceLocation> getChunkTextures(LevelChunk chunk) {
        HashSet<ResourceLocation> textures = new HashSet<ResourceLocation>();
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.m_91087_().m_91289_();
        for (BlockPos pos : BlockPos.m_121976_((int)chunk.m_7697_().m_45604_(), (int)0, (int)chunk.m_7697_().m_45605_(), (int)chunk.m_7697_().m_45608_(), (int)chunk.m_62953_().m_141928_(), (int)chunk.m_7697_().m_45609_())) {
            BlockState blockState = chunk.m_8055_(pos);
            BakedModel model = blockRenderDispatcher.m_110910_(blockState);
            model.m_213637_(blockState, null, RandomSource.m_216327_()).forEach(quad -> {
                SpriteContents spriteContents = quad.m_173410_().m_245424_();
                ResourceLocation textureLocation = spriteContents.m_246162_();
                textures.add(textureLocation);
            });
        }
        return textures;
    }
}

