/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core.other;

import com.teamabnormals.caverns_and_chasms.common.item.BejeweledPearlItem;
import com.teamabnormals.caverns_and_chasms.core.CCConfig;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBlocks;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="caverns_and_chasms", value={Dist.CLIENT})
public class CCClientCompat {
    public static void registerClientCompat() {
        CCClientCompat.registerRenderLayers();
        CCClientCompat.registerItemProperties();
    }

    public static void registerRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.COPPER_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.EXPOSED_COPPER_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.WEATHERED_COPPER_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.OXIDIZED_COPPER_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.WAXED_COPPER_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.WAXED_EXPOSED_COPPER_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.WAXED_WEATHERED_COPPER_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.WAXED_OXIDIZED_COPPER_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.GOLDEN_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.SILVER_BARS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.SPIKED_RAIL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.BRAZIER.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.SOUL_BRAZIER.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.ENDER_BRAZIER.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.CUPRIC_BRAZIER.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.CUPRIC_FIRE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.CUPRIC_TORCH.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.CUPRIC_WALL_TORCH.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.CUPRIC_LANTERN.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.CUPRIC_CAMPFIRE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.AZALEA_LADDER.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.AZALEA_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CCBlocks.AZALEA_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
    }

    public static void registerItemProperties() {
        ItemProperties.register((Item)((Item)CCItems.GOLDEN_BUCKET.get()), (ResourceLocation)new ResourceLocation("caverns_and_chasms", "level"), (stack, level, entity, hash) -> stack.m_41784_().m_128451_("FluidLevel"));
        ItemProperties.register((Item)((Item)CCItems.GOLDEN_WATER_BUCKET.get()), (ResourceLocation)new ResourceLocation("caverns_and_chasms", "level"), (stack, level, entity, hash) -> stack.m_41784_().m_128451_("FluidLevel"));
        ItemProperties.register((Item)((Item)CCItems.GOLDEN_LAVA_BUCKET.get()), (ResourceLocation)new ResourceLocation("caverns_and_chasms", "level"), (stack, level, entity, hash) -> stack.m_41784_().m_128451_("FluidLevel"));
        ItemProperties.register((Item)((Item)CCItems.GOLDEN_MILK_BUCKET.get()), (ResourceLocation)new ResourceLocation("caverns_and_chasms", "level"), (stack, level, entity, hash) -> stack.m_41784_().m_128451_("FluidLevel"));
        ItemProperties.register((Item)((Item)CCItems.GOLDEN_POWDER_SNOW_BUCKET.get()), (ResourceLocation)new ResourceLocation("caverns_and_chasms", "level"), (stack, level, entity, hash) -> stack.m_41784_().m_128451_("FluidLevel"));
        ItemProperties.register((Item)Items.f_42717_, (ResourceLocation)new ResourceLocation("caverns_and_chasms", "blunt_arrow"), (stack, level, entity, hash) -> entity != null && CrossbowItem.m_40932_((ItemStack)stack) && CrossbowItem.m_40871_((ItemStack)stack, (Item)((Item)CCItems.BLUNT_ARROW.get())) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)CCItems.LOST_GOAT_HORN.get()), (ResourceLocation)new ResourceLocation("tooting"), (stack, level, entity, hash) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)Items.f_151058_, (ResourceLocation)new ResourceLocation("dyed"), (stack, level, entity, hash) -> ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack) > 0 ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)CCItems.TUNING_FORK.get()), (ResourceLocation)new ResourceLocation("caverns_and_chasms", "holding"), (stack, level, entity, hash) -> stack.m_41784_().m_128441_("Note") ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)CCItems.DEPTH_GAUGE.get()), (ResourceLocation)new ResourceLocation("caverns_and_chasms", "depth"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            private double rotation;
            private double rota;
            private long lastUpdateTick;

            public float m_142187_(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, int p_174668_) {
                double depth;
                Level level2;
                LivingEntity entity;
                Object object = entity = livingEntity != null ? livingEntity : stack.m_41609_();
                if (entity == null) {
                    return 0.33333f;
                }
                if (level == null && (level2 = entity.m_9236_()) instanceof ClientLevel) {
                    ClientLevel clientLevel;
                    level = clientLevel = (ClientLevel)level2;
                }
                if (level == null) {
                    return 0.33333f;
                }
                if (level.m_6042_().f_63858_()) {
                    DecimalFormat format = new DecimalFormat("0.00000", DecimalFormatSymbols.getInstance(Locale.ROOT));
                    int height = (Mth.m_14045_((int)((int)entity.m_20186_() - 1), (int)-64, (int)320) + 64) / 8;
                    depth = (double)height / 48.0;
                    depth = Float.parseFloat(format.format(depth));
                } else {
                    depth = Math.random();
                    depth = this.wobble((Level)level, depth);
                }
                return (float)depth;
            }

            private double wobble(Level level, double depth) {
                if (level.m_46467_() != this.lastUpdateTick) {
                    this.lastUpdateTick = level.m_46467_();
                    double d0 = depth - this.rotation;
                    this.rota += d0 * 0.05;
                    this.rota *= 0.8;
                    this.rotation += this.rota;
                }
                return this.rotation;
            }
        });
        ItemProperties.register((Item)((Item)CCItems.BEJEWELED_PEARL.get()), (ResourceLocation)new ResourceLocation("caverns_and_chasms", "charge"), (stack, level, entity, hash) -> {
            if (entity != null && entity.m_21211_() == stack) {
                return (float)BejeweledPearlItem.getChargeStage(stack.m_41779_() - entity.m_21212_()) / (float)BejeweledPearlItem.getChargeStages();
            }
            if (stack.m_41784_().m_128441_("Life")) {
                return (float)BejeweledPearlItem.getChargeStage(stack.m_41783_().m_128451_("Life")) / (float)BejeweledPearlItem.getChargeStages();
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)CCItems.BAROMETER.get()), (ResourceLocation)new ResourceLocation("caverns_and_chasms", "weather"), (ItemPropertyFunction)((ClampedItemPropertyFunction)(stack, level, livingEntity, seed) -> {
            Level patt8380$temp;
            LivingEntity entity;
            Object object = entity = livingEntity != null ? livingEntity : stack.m_41609_();
            if (entity == null) {
                return 0.4f;
            }
            if (level == null && (patt8380$temp = entity.m_9236_()) instanceof ClientLevel) {
                ClientLevel clientLevel;
                level = clientLevel = (ClientLevel)patt8380$temp;
            }
            if (level == null) {
                return 0.4f;
            }
            DecimalFormat format = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.ROOT));
            Biome.Precipitation precipitation = ((Biome)level.m_204166_(entity.m_20183_()).m_203334_()).m_264600_(entity.m_20183_());
            float max = !level.m_6042_().f_223549_() || level.m_6042_().f_63856_() ? 0.2f : (precipitation == Biome.Precipitation.NONE ? 0.4f : (level.m_46470_() ? 0.8f : (level.m_46471_() ? (precipitation == Biome.Precipitation.SNOW ? 1.0f : 0.6f) : 0.4f)));
            return Float.parseFloat(format.format(max));
        }));
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        Player player = event.getEntity();
        if (player != null && player.m_150109_().m_36063_(stack)) {
            Level level = player.m_9236_();
            if (item == Items.f_42522_ && ((Boolean)CCConfig.CLIENT.compassesDisplayPosition.get()).booleanValue()) {
                event.getToolTip().add(CCClientCompat.createTooltip("latitude").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.format(Locale.ROOT, ": %.3f", player.m_20185_())).m_130940_(ChatFormatting.GRAY)));
                event.getToolTip().add(CCClientCompat.createTooltip("longitude").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.format(Locale.ROOT, ": %.3f", player.m_20189_())).m_130940_(ChatFormatting.GRAY)));
            }
            if (item == Items.f_42524_) {
                if (((Boolean)CCConfig.CLIENT.clocksDisplayTime.get()).booleanValue()) {
                    event.getToolTip().add(Component.m_237113_((String)CCClientCompat.calculateTime(level)).m_130940_(ChatFormatting.GRAY));
                }
                if (((Boolean)CCConfig.CLIENT.clocksDisplayDay.get()).booleanValue()) {
                    event.getToolTip().add(CCClientCompat.createTooltip("day").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(" " + level.m_46468_() / 24000L)).m_130940_(ChatFormatting.GRAY)));
                }
            }
            if (item == CCItems.DEPTH_GAUGE.get() && ((Boolean)CCConfig.CLIENT.depthGaugesDisplayPosition.get()).booleanValue()) {
                event.getToolTip().add(CCClientCompat.createTooltip("altitude").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.format(Locale.ROOT, ": %.3f", player.m_20186_())).m_130940_(ChatFormatting.GRAY)));
            }
            if (item == CCItems.BAROMETER.get() && ((Boolean)CCConfig.CLIENT.barometersDisplayWeather.get()).booleanValue()) {
                event.getToolTip().add(CCClientCompat.createTooltip("weather").m_130940_(ChatFormatting.GRAY).m_130946_(": ").m_7220_((Component)CCClientCompat.createTooltip(CCClientCompat.getWeather(player, level)).m_130940_(ChatFormatting.GRAY)));
            }
        }
    }

    private static String getWeather(Player player, Level level) {
        Biome.Precipitation precipitation = ((Biome)level.m_204166_(player.m_20183_()).m_203334_()).m_264600_(player.m_20183_());
        if (precipitation != Biome.Precipitation.NONE) {
            if (level.m_46470_()) {
                return "stormy";
            }
            if (level.m_46471_()) {
                if (precipitation == Biome.Precipitation.SNOW) {
                    return "snowy";
                }
                return "rainy";
            }
        }
        return level.m_6042_().f_223549_() && !level.m_6042_().f_63856_() ? "clear" : "null";
    }

    private static MutableComponent createTooltip(String identifier) {
        return Component.m_237115_((String)("tooltip.caverns_and_chasms." + identifier));
    }

    private static String calculateTime(Level level) {
        Object addition = "";
        int totalMinutes = (int)(level.m_8044_() * 3L / 50L);
        int hour = 6 + totalMinutes / 60;
        if (hour >= 24) {
            hour %= 24;
        }
        int minute = totalMinutes % 60;
        if (!((Boolean)CCConfig.CLIENT.clocksUse24hrTime.get()).booleanValue()) {
            addition = " " + (hour > 11 ? CCClientCompat.createTooltip("pm").getString() : CCClientCompat.createTooltip("am").getString());
            hour = hour > 12 ? hour - 12 : (hour == 0 ? 12 : hour);
        }
        String stringMinute = (minute < 10 ? "0" : "") + minute;
        return hour + ":" + stringMinute + (String)addition;
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        Item item = event.getItemStack().m_41720_();
        Level level = player.m_9236_();
        boolean displayTime = (Boolean)CCConfig.CLIENT.clocksDisplayTime.get();
        boolean displayDay = (Boolean)CCConfig.CLIENT.clocksDisplayDay.get();
        if (item == Items.f_42522_ && ((Boolean)CCConfig.CLIENT.compassesDisplayPosition.get()).booleanValue()) {
            player.m_5661_((Component)CCClientCompat.createTooltip("latitude").m_7220_((Component)Component.m_237113_((String)String.format(Locale.ROOT, ": %.3f, ", player.m_20185_())).m_7220_((Component)CCClientCompat.createTooltip("longitude").m_7220_((Component)Component.m_237113_((String)String.format(Locale.ROOT, ": %.3f", player.m_20189_()))))), true);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
        } else if (item == Items.f_42524_ && (displayDay || displayTime)) {
            MutableComponent time = Component.m_237113_((String)CCClientCompat.calculateTime(level));
            MutableComponent day = CCClientCompat.createTooltip("day").m_7220_((Component)Component.m_237113_((String)(" " + (level.m_46468_() + 6000L) / 24000L)));
            MutableComponent message = Component.m_237113_((String)"");
            if (((Boolean)CCConfig.CLIENT.clocksDisplayTime.get()).booleanValue()) {
                message.m_7220_((Component)time);
                if (displayDay) {
                    message.m_7220_((Component)Component.m_237113_((String)", "));
                }
            }
            if (displayDay) {
                message.m_7220_((Component)day);
            }
            player.m_5661_((Component)message, true);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
        } else if (item == CCItems.DEPTH_GAUGE.get() && ((Boolean)CCConfig.CLIENT.depthGaugesDisplayPosition.get()).booleanValue()) {
            player.m_5661_((Component)CCClientCompat.createTooltip("altitude").m_7220_((Component)Component.m_237113_((String)String.format(Locale.ROOT, ": %.3f", player.m_20186_()))), true);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
        } else if (item == CCItems.BAROMETER.get() && ((Boolean)CCConfig.CLIENT.barometersDisplayWeather.get()).booleanValue()) {
            player.m_5661_((Component)CCClientCompat.createTooltip("weather").m_130946_(": ").m_7220_((Component)CCClientCompat.createTooltip(CCClientCompat.getWeather(player, level))), true);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
        }
    }
}

