/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.entity.animal;

import com.teamabnormals.caverns_and_chasms.common.entity.ai.goal.FollowLikedPlayerGoal;
import com.teamabnormals.caverns_and_chasms.common.entity.ai.goal.GoToDarkSpotGoal;
import com.teamabnormals.caverns_and_chasms.core.other.tags.CCBlockTags;
import com.teamabnormals.caverns_and_chasms.core.other.tags.CCItemTags;
import com.teamabnormals.caverns_and_chasms.core.registry.CCSoundEvents;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;

public class Glare
extends PathfinderMob {
    private static final EntityDataAccessor<Boolean> DATA_GRUMPY = SynchedEntityData.m_135353_(Glare.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID = SynchedEntityData.m_135353_(Glare.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_ANGRY_AT_UUID = SynchedEntityData.m_135353_(Glare.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public Glare(EntityType<? extends Glare> glare, Level level) {
        super(glare, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22280_, (double)0.1f).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new FollowLikedPlayerGoal(this, 1.75));
        this.f_21345_.m_25352_(3, (Goal)new GoToDarkSpotGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_GRUMPY, (Object)false);
        this.f_19804_.m_135372_(DATA_OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_ANGRY_AT_UUID, Optional.empty());
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.getOwnerUUID() != null) {
            tag.m_128362_("Owner", this.getOwnerUUID());
        }
        if (this.getAngryAtUUID() != null) {
            tag.m_128362_("AngryAt", this.getAngryAtUUID());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("Owner")) {
            this.setOwnerUUID(tag.m_128342_("Owner"));
        }
        if (tag.m_128403_("AngryAt")) {
            this.setAngryAtUUID(tag.m_128342_("AngryAt"));
        }
    }

    public static boolean checkGlareSpawnRules(EntityType<? extends Glare> glare, LevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource random) {
        if (pos.m_123342_() < 48 && level.m_45517_(LightLayer.SKY, pos) == 0) {
            int plants = 0;
            int range = 5;
            block0: for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    for (int k = -range; k <= range; ++k) {
                        if (level.m_8055_(pos.m_7918_(i, j, k)).m_204336_(CCBlockTags.GLARE_SPAWNABLE_NEAR) && ++plants > 10) break block0;
                    }
                }
            }
            return plants > 0 && (plants > 10 || random.m_188503_(plants) != 0);
        }
        return false;
    }

    protected PathNavigation m_6037_(Level p_218342_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_218342_);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public static boolean shouldBeGrumpy(Level level, BlockPos pos) {
        DimensionType dimension = level.m_6042_();
        int i = dimension.m_223570_();
        return i >= 15 || level.m_45517_(LightLayer.BLOCK, pos) <= i;
    }

    public boolean isGrumpy() {
        return (Boolean)this.f_19804_.m_135370_(DATA_GRUMPY);
    }

    public void setGrumpy(boolean grumpy) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_GRUMPY, (Object)grumpy);
        }
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public UUID getAngryAtUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_ANGRY_AT_UUID)).orElse(null);
    }

    public void setAngryAtUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_ANGRY_AT_UUID, Optional.ofNullable(uuid));
    }

    public void m_7023_(Vec3 p_218382_) {
        if (this.m_21515_() || this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        }
        this.m_267651_(false);
    }

    protected float m_6431_(Pose p_218356_, EntityDimensions p_218357_) {
        return p_218357_.f_20378_ * 0.6f;
    }

    public boolean m_142535_(float p_218321_, float p_218322_, DamageSource p_218323_) {
        return false;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        Entity attacker = source.m_7639_();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (this.getOwnerUUID() != null && player.m_20148_().equals(this.getOwnerUUID())) {
                this.m_5496_((SoundEvent)CCSoundEvents.ENTITY_GLARE_UNTAME.get(), 1.0f, 1.0f);
                this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123792_);
                this.setOwnerUUID(null);
            }
            this.setAngryAtUUID(player.m_20148_());
        }
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            damage *= 2.0f;
        }
        return super.m_6469_(source, damage);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    protected void m_7840_(double p_218316_, boolean p_218317_, BlockState p_218318_, BlockPos p_218319_) {
    }

    protected SoundEvent m_7515_() {
        return this.isGrumpy() ? (SoundEvent)CCSoundEvents.ENTITY_GLARE_ANGRY.get() : (SoundEvent)CCSoundEvents.ENTITY_GLARE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_218369_) {
        return (SoundEvent)CCSoundEvents.ENTITY_GLARE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CCSoundEvents.ENTITY_GLARE_DEATH.get();
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public void m_8107_() {
        super.m_8107_();
        boolean shouldBeGrumpy = Glare.shouldBeGrumpy(this.m_9236_(), this.m_20183_());
        if (this.isGrumpy() && !shouldBeGrumpy || !this.isGrumpy() && shouldBeGrumpy) {
            this.setGrumpy(!this.isGrumpy());
            this.m_8032_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(CCItemTags.GLARE_FOOD)) {
            this.m_9236_().m_6269_(player, (Entity)this, (SoundEvent)CCSoundEvents.ENTITY_GLARE_EAT.get(), this.m_5720_(), 1.0f, Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123750_);
            this.removeInteractionItem(player, stack);
            this.setAngryAtUUID(null);
            if (this.getOwnerUUID() == null) {
                this.m_5496_((SoundEvent)CCSoundEvents.ENTITY_GLARE_TAME.get(), 1.0f, 1.0f);
                this.setOwnerUUID(player.m_20148_());
            }
            return InteractionResult.SUCCESS;
        }
        if (this.getOwnerUUID() == null && this.getAngryAtUUID() != player.m_20148_()) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123750_);
            this.setOwnerUUID(player.m_20148_());
            this.m_5496_((SoundEvent)CCSoundEvents.ENTITY_GLARE_TAME.get(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_142039_() {
        return !this.m_20096_();
    }

    public boolean m_6785_(double p_218384_) {
        return this.getOwnerUUID() == null;
    }

    public boolean m_21532_() {
        return this.getOwnerUUID() != null;
    }

    protected boolean m_213814_() {
        return true;
    }

    private void removeInteractionItem(Player player, ItemStack stack) {
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * 0.6, (double)this.m_20205_() * 0.1);
    }

    public void m_7822_(byte p_239347_) {
        if (p_239347_ == 18) {
            for (int i = 0; i < 3; ++i) {
                this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123750_);
            }
        } else {
            super.m_7822_(p_239347_);
        }
    }

    protected void addParticlesAroundSelf(ParticleOptions p_35288_) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(p_35288_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }
}

