/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.block;

import com.teamabnormals.caverns_and_chasms.common.block.CCWeatheringCopper;
import com.teamabnormals.caverns_and_chasms.common.block.WeatheringToolboxBlock;
import com.teamabnormals.caverns_and_chasms.common.block.entity.ToolboxBlockEntity;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBlockEntityTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ToolboxBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty HANGING = BooleanProperty.m_61465_((String)"hanging");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    private final WeatheringCopper.WeatherState weatherState;
    public static final VoxelShape SHAPE_X = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0);
    public static final VoxelShape SHAPE_Z = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0);
    public static final VoxelShape SHAPE_X_HANGING = SHAPE_X.m_83216_(0.0, 0.3125, 0.0);
    public static final VoxelShape SHAPE_Z_HANGING = SHAPE_Z.m_83216_(0.0, 0.3125, 0.0);

    public ToolboxBlock(WeatheringCopper.WeatherState p_56188_, BlockBehaviour.Properties p_56189_) {
        super(p_56189_);
        this.weatherState = p_56188_;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ToolboxBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return ToolboxBlock.m_152132_(entityType, (BlockEntityType)((BlockEntityType)CCBlockEntityTypes.TOOLBOX.get()), ToolboxBlockEntity::tick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!(this instanceof WeatheringToolboxBlock) && player.m_21120_(hand).m_204117_(ItemTags.f_271207_)) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ToolboxBlockEntity) {
            ToolboxBlockEntity toolbox = (ToolboxBlockEntity)blockEntity;
            player.m_5893_((MenuProvider)toolbox);
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        boolean hanging = context.m_43719_() == Direction.DOWN;
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)direction)).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(hanging))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, offsetState, level, pos, offsetPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pathComputationType) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HANGING, WATERLOGGED});
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof ToolboxBlockEntity) {
            ToolboxBlockEntity toolbox = (ToolboxBlockEntity)blockentity;
            if (!level.f_46443_ && player.m_7500_() && !toolbox.m_7983_()) {
                ItemStack itemstack = ToolboxBlock.getWeatheredItemStack(this.getWeatherState(), this instanceof CCWeatheringCopper);
                blockentity.m_187476_(itemstack);
                if (toolbox.m_8077_()) {
                    itemstack.m_41714_(toolbox.m_7770_());
                }
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            } else {
                toolbox.m_59640_(player);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof ToolboxBlockEntity) {
            ToolboxBlockEntity toolbox = (ToolboxBlockEntity)blockEntity;
            builder = builder.m_287145_(CONTENTS, p_56218_ -> {
                for (int i = 0; i < toolbox.m_6643_(); ++i) {
                    p_56218_.accept(toolbox.m_8020_(i));
                }
            });
        }
        return super.m_49635_(state, builder);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof ToolboxBlockEntity) {
            ToolboxBlockEntity toolbox = (ToolboxBlockEntity)blockEntity;
            toolbox.m_58638_(stack.m_41786_());
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState p_56237_, boolean p_56238_) {
        if (!state.m_60713_(p_56237_.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ToolboxBlockEntity) {
                level.m_46717_(pos, state.m_60734_());
            }
            super.m_6810_(state, level, pos, p_56237_, p_56238_);
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> components, TooltipFlag flag) {
        super.m_5871_(stack, level, components, flag);
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        if (tag != null) {
            if (tag.m_128425_("LootTable", 8)) {
                components.add((Component)Component.m_237113_((String)"???????"));
            }
            if (tag.m_128425_("Items", 9)) {
                NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.m_41619_()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    components.add((Component)itemstack.m_41786_().m_6881_());
                }
                if (j - i > 0) {
                    components.add((Component)Component.m_237110_((String)"container.caverns_and_chasms.toolbox.more", (Object[])new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC));
                }
            }
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean hanging = (Boolean)state.m_61143_((Property)HANGING);
        return ((Direction)state.m_61143_(FACING)).m_122434_() == Direction.Axis.X ? (!hanging ? SHAPE_X : SHAPE_X_HANGING) : (!hanging ? SHAPE_Z : SHAPE_Z_HANGING);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38938_((Container)((Container)level.m_7702_(pos)));
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        level.m_141902_(pos, (BlockEntityType)CCBlockEntityTypes.TOOLBOX.get()).ifPresent(block -> block.m_187476_(stack));
        return stack;
    }

    public static Block getBlockByWeatherState(WeatheringCopper.WeatherState weatherState, boolean weathers) {
        if (weathers) {
            return switch (weatherState) {
                default -> throw new IncompatibleClassChangeError();
                case WeatheringCopper.WeatherState.UNAFFECTED -> (Block)CCBlocks.TOOLBOX.get();
                case WeatheringCopper.WeatherState.EXPOSED -> (Block)CCBlocks.EXPOSED_TOOLBOX.get();
                case WeatheringCopper.WeatherState.WEATHERED -> (Block)CCBlocks.WEATHERED_TOOLBOX.get();
                case WeatheringCopper.WeatherState.OXIDIZED -> (Block)CCBlocks.OXIDIZED_TOOLBOX.get();
            };
        }
        return switch (weatherState) {
            default -> throw new IncompatibleClassChangeError();
            case WeatheringCopper.WeatherState.UNAFFECTED -> (Block)CCBlocks.WAXED_TOOLBOX.get();
            case WeatheringCopper.WeatherState.EXPOSED -> (Block)CCBlocks.WAXED_EXPOSED_TOOLBOX.get();
            case WeatheringCopper.WeatherState.WEATHERED -> (Block)CCBlocks.WAXED_WEATHERED_TOOLBOX.get();
            case WeatheringCopper.WeatherState.OXIDIZED -> (Block)CCBlocks.WAXED_OXIDIZED_TOOLBOX.get();
        };
    }

    public WeatheringCopper.WeatherState getWeatherState() {
        return this.weatherState;
    }

    public static ItemStack getWeatheredItemStack(WeatheringCopper.WeatherState weatherState, boolean weathers) {
        return new ItemStack((ItemLike)ToolboxBlock.getBlockByWeatherState(weatherState, weathers));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_(FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_(FACING)));
    }
}

