/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.blueprint.client.BlueprintRenderTypes;
import com.teamabnormals.caverns_and_chasms.client.resources.DeeperSpriteUploader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DeeperModel<T extends Entity>
extends ListModel<T> {
    private final DeeperSprite sprite;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;

    public DeeperModel(DeeperSprite sprite, ModelPart root) {
        this.sprite = sprite;
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.leg1 = root.m_171324_("leg1");
        this.leg2 = root.m_171324_("leg2");
        this.leg3 = root.m_171324_("leg3");
        this.leg4 = root.m_171324_("leg4");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, deformation).m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.3f, 0.3f, 0.3f)), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -18.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation).m_171514_(40, 16).m_171488_(-4.0f, -18.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.3f, 0.3f, 0.3f)), PartPose.m_171423_((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.m_171423_((float)-2.0f, (float)18.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.m_171423_((float)2.0f, (float)18.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("leg3", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.m_171423_((float)-2.0f, (float)18.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("leg4", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.m_171423_((float)2.0f, (float)18.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.sprite != null) {
            TextureAtlasSprite textureatlassprite = DeeperSpriteUploader.getSprite(this.sprite);
            RenderType render = this.sprite == DeeperSprite.PRIMED ? RenderType.m_110473_((ResourceLocation)DeeperSpriteUploader.ATLAS_LOCATION) : (this.sprite == DeeperSprite.EMISSIVE ? BlueprintRenderTypes.getUnshadedTranslucentEntity((ResourceLocation)DeeperSpriteUploader.ATLAS_LOCATION, (boolean)false) : RenderType.m_110452_((ResourceLocation)DeeperSpriteUploader.ATLAS_LOCATION));
            super.m_7695_(matrixStack, textureatlassprite.m_118381_(Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(render)), this.sprite == DeeperSprite.EMISSIVE ? 0xF000F0 : packedLight, packedOverlay, red, green, blue, alpha);
        } else {
            super.m_7695_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.leg1, (Object)this.leg2, (Object)this.leg3, (Object)this.leg4);
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.leg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg2.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg3.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg4.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum DeeperSprite {
        BASE,
        PRIMED,
        EMISSIVE;

    }
}

