/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.builtinservers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import io.github.lucaargolo.builtinservers.BuiltinServerInfo;
import io.github.lucaargolo.builtinservers.ModConfig;
import io.github.lucaargolo.builtinservers.mixed.MixedServerInfo;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BuiltinServers {
    public static final String MODID = "builtinservers";
    public static final Logger LOGGER = LogManager.getLogger((String)"Builtin Servers");
    public static ModConfig CONFIG;
    private static final Gson gson;

    public static void initializeClient(Path configPath, @Nullable Consumer<Consumer<Minecraft>> eventRegister_clientStarted) {
        block11: {
            File configFile = new File(configPath + File.separator + "builtinservers.json");
            LOGGER.info("Trying to read servers file...");
            try {
                if (configFile.createNewFile()) {
                    LOGGER.info("No servers file found, creating a new one...");
                    String json = gson.toJson(JsonParser.parseString((String)gson.toJson((Object)new ModConfig())));
                    try (PrintWriter out = new PrintWriter(configFile);){
                        out.println(json);
                    }
                    CONFIG = new ModConfig();
                    LOGGER.info("Successfully created default servers file.");
                    break block11;
                }
                LOGGER.info("A servers file was found, loading it..");
                CONFIG = (ModConfig)gson.fromJson(new String(Files.readAllBytes(configFile.toPath())), ModConfig.class);
                if (CONFIG == null) {
                    throw new NullPointerException("The servers file was empty.");
                }
                LOGGER.info("Successfully loaded servers file.");
            }
            catch (Exception exception) {
                LOGGER.error("There was an error creating/loading the servers file!", (Throwable)exception);
                CONFIG = new ModConfig();
                LOGGER.warn("Defaulting to original servers file.");
            }
        }
        if (eventRegister_clientStarted != null) {
            eventRegister_clientStarted.accept(BuiltinServers::onClientStarted);
        }
    }

    public static void onClientStarted(Minecraft client) {
        ServerList serverList = new ServerList(client);
        serverList.m_105431_();
        if (serverList.m_105445_() == 0) {
            CONFIG.getBuiltinServers().forEach(serverConfig -> {
                BuiltinServerInfo builtinServer = new BuiltinServerInfo(serverConfig.getName(), serverConfig.getAddress(), serverConfig.isForced());
                serverList.m_233842_((ServerData)builtinServer, false);
            });
        } else {
            List<ModConfig.ServerConfig> forcedConfigs = CONFIG.getBuiltinServers().stream().filter(ModConfig.ServerConfig::isForced).collect(Collectors.toList());
            ArrayList<ModConfig.ServerConfig> savedServers = new ArrayList<ModConfig.ServerConfig>(serverList.m_105445_());
            for (int i = 0; i != serverList.m_105445_(); ++i) {
                ServerData savedServer = serverList.m_105432_(i);
                if (!((MixedServerInfo)savedServer).builtinservers_isForced()) continue;
                ModConfig.ServerConfig savedServerConfig = ModConfig.ServerConfig.fromServerInfo(savedServer);
                savedServers.add(savedServerConfig);
                if (forcedConfigs.contains(savedServerConfig)) continue;
                ((MixedServerInfo)savedServer).builtinservers_setForced(false);
            }
            forcedConfigs.removeAll(savedServers);
            forcedConfigs.forEach(serverConfig -> {
                BuiltinServerInfo builtinServer = new BuiltinServerInfo(serverConfig.getName(), serverConfig.getAddress(), true);
                serverList.m_233842_((ServerData)builtinServer, false);
            });
        }
        serverList.m_105442_();
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

