/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.core.other;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamabnormals.blueprint.common.entity.BlueprintBoat;
import com.teamabnormals.blueprint.common.entity.BlueprintChestBoat;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.core.registry.BlueprintBoatTypes;
import com.teamabnormals.boatload.common.entity.vehicle.BoatloadBoat;
import com.teamabnormals.boatload.common.entity.vehicle.LargeBoat;
import com.teamabnormals.boatload.common.item.FurnaceBoatItem;
import com.teamabnormals.boatload.common.item.LargeBoatItem;
import com.teamabnormals.boatload.core.Boatload;
import com.teamabnormals.boatload.core.api.BoatloadBoatType;
import com.teamabnormals.boatload.core.other.BoatloadTrackedData;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.joml.Quaternionf;

public class BoatloadUtil {
    public static List<Item> getItems() {
        ArrayList items = Lists.newArrayList();
        Boatload.REGISTRY_HELPER.getItemSubHelper().getDeferredRegister().getEntries().forEach(registryObject -> items.add((Item)registryObject.get()));
        return items;
    }

    public static List<FurnaceBoatItem> getFurnaceBoats() {
        return BoatloadUtil.getItems().stream().filter(item -> item instanceof FurnaceBoatItem).collect(Collectors.toList());
    }

    public static List<LargeBoatItem> getLargeBoats() {
        return BoatloadUtil.getItems().stream().filter(item -> item instanceof LargeBoatItem).collect(Collectors.toList());
    }

    public static boolean isNetherBoat(Entity entity) {
        if (entity instanceof BoatloadBoat) {
            BoatloadBoat boat = (BoatloadBoat)entity;
            return boat.getBoatloadBoatType().fireproof();
        }
        BlueprintBoatTypes.BlueprintBoatType typeData = null;
        if (entity instanceof BlueprintBoat) {
            BlueprintBoat boat = (BlueprintBoat)entity;
            typeData = boat.getBoatType();
        } else if (entity instanceof BlueprintChestBoat) {
            BlueprintChestBoat boat = (BlueprintChestBoat)entity;
            typeData = boat.getBoatType();
        }
        return typeData != null && BoatloadBoatType.getType(typeData.getName()).fireproof();
    }

    public static void renderBanner(Boat boat, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLightIn) {
        ItemStack banner;
        float f2;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.375, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        float f = (float)boat.m_38385_() - partialTicks;
        float f1 = boat.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = boat.m_38352_(partialTicks)), (float)0.0f)) {
            poseStack.m_252781_(new Quaternionf().setAngleAxis(boat.m_38352_(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        if ((banner = (ItemStack)((IDataManager)boat).getValue(BoatloadTrackedData.BANNER)) != null && banner.m_41720_() instanceof BannerItem) {
            BlueprintBoat blueprintBoat;
            BoatloadBoat boatloadBoat;
            boolean raft;
            Level level = boat.m_20193_();
            int i = level != null ? LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)boat.m_20183_()) : 0xF000F0;
            boolean bl = raft = boat.m_28554_() == Boat.Type.BAMBOO || boat instanceof BoatloadBoat && (boatloadBoat = (BoatloadBoat)boat).getBoatloadBoatType().raft() || boat instanceof BlueprintBoat && (blueprintBoat = (BlueprintBoat)boat).getBoatType().isRaft();
            float f3 = boat instanceof LargeBoat ? (raft ? 27.0f : 36.0f) : (raft ? 21.0f : 23.0f);
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, (double)((raft ? 2.0f : 3.0f) / 16.0f), (double)(f3 / 16.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            IClientItemExtensions.of((ItemStack)banner).getCustomRenderer().m_108829_(banner, ItemDisplayContext.GROUND, poseStack, buffer, i, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }
}

