/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.client.model;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.boatload.common.entity.vehicle.LargeBoat;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class WideRaftModel
extends ListModel<LargeBoat> {
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;
    private final ImmutableList<ModelPart> parts;

    public WideRaftModel(ModelPart root) {
        this.leftPaddle = root.m_171324_("left_paddle");
        this.rightPaddle = root.m_171324_("right_paddle");
        this.parts = this.createPartsBuilder(root).build();
    }

    protected ImmutableList.Builder<ModelPart> createPartsBuilder(ModelPart modelPart) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object[])new ModelPart[]{modelPart.m_171324_("bottom"), this.leftPaddle, this.rightPaddle});
        return builder;
    }

    public static void createChildren(PartDefinition partdefinition) {
        partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-20.0f, -21.0f, -4.0f, 40.0f, 40.0f, 4.0f).m_171514_(0, 0).m_171481_(-20.0f, -19.0f, -8.0f, 40.0f, 36.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)1.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("left_paddle", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-4.0f, (float)19.0f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        partdefinition.m_171599_("right_paddle", CubeListBuilder.m_171558_().m_171514_(40, 44).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-4.0f, (float)-19.0f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        WideRaftModel.createChildren(partdefinition);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(LargeBoat p_249733_, float p_249202_, float p_252219_, float p_249366_, float p_249759_, float p_250286_) {
        WideRaftModel.animatePaddle(p_249733_, 0, this.leftPaddle, p_249202_);
        WideRaftModel.animatePaddle(p_249733_, 1, this.rightPaddle, p_249202_);
    }

    public ImmutableList<ModelPart> parts() {
        return this.parts;
    }

    private static void animatePaddle(LargeBoat boat, int p_249947_, ModelPart p_248943_, float p_251990_) {
        float f = boat.m_38315_(p_249947_, p_251990_);
        p_248943_.f_104203_ = Mth.m_144920_((float)-1.0471976f, (float)-0.2617994f, (float)((Mth.m_14031_((float)(-f)) + 1.0f) / 2.0f));
        p_248943_.f_104204_ = Mth.m_144920_((float)-0.7853982f, (float)0.7853982f, (float)((Mth.m_14031_((float)(-f + 1.0f)) + 1.0f) / 2.0f));
        if (p_249947_ == 1) {
            p_248943_.f_104204_ = (float)Math.PI - p_248943_.f_104204_;
        }
    }
}

