/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.client.model;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.boatload.common.entity.vehicle.LargeBoat;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LargeBoatModel
extends ListModel<LargeBoat>
implements WaterPatchModel {
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;
    private final ModelPart waterPatch;
    private final ImmutableList<ModelPart> parts;

    public LargeBoatModel(ModelPart root) {
        this.leftPaddle = root.m_171324_("left_paddle");
        this.rightPaddle = root.m_171324_("right_paddle");
        this.waterPatch = root.m_171324_("water_patch");
        this.parts = ImmutableList.of((Object)root.m_171324_("bottom"), (Object)root.m_171324_("back"), (Object)root.m_171324_("front"), (Object)root.m_171324_("right"), (Object)root.m_171324_("left"), (Object)this.leftPaddle, (Object)this.rightPaddle);
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-27.0f, -11.5f, -3.0f, 54.0f, 21.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        root.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171481_(-15.5f, -7.0f, -1.0f, 23.0f, 6.0f, 2.0f), PartPose.m_171423_((float)-28.0f, (float)4.0f, (float)4.0f, (float)0.0f, (float)4.712389f, (float)0.0f));
        root.m_171599_("front", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-9.5f, -7.0f, -1.0f, 21.0f, 6.0f, 2.0f), PartPose.m_171423_((float)28.0f, (float)4.0f, (float)1.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        root.m_171599_("right", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171481_(-27.0f, -7.0f, -1.0f, 54.0f, 6.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-11.5f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        root.m_171599_("left", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171481_(-27.0f, -7.0f, -1.0f, 54.0f, 6.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)11.5f));
        root.m_171599_("left_paddle", CubeListBuilder.m_171558_().m_171514_(0, 56).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)11.5f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        root.m_171599_("right_paddle", CubeListBuilder.m_171558_().m_171514_(0, 76).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)-11.5f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
        root.m_171599_("water_patch", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-27.0f, -11.5f, -3.0f, 54.0f, 21.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void setupAnim(LargeBoat boat, float p_102270_, float p_102271_, float p_102272_, float p_102273_, float p_102274_) {
        LargeBoatModel.animatePaddle(boat, 0, this.leftPaddle, p_102270_);
        LargeBoatModel.animatePaddle(boat, 1, this.rightPaddle, p_102270_);
    }

    public ImmutableList<ModelPart> parts() {
        return this.parts;
    }

    public ModelPart m_102282_() {
        return this.waterPatch;
    }

    private static void animatePaddle(LargeBoat boat, int p_170466_, ModelPart p_170467_, float p_170468_) {
        float f = boat.m_38315_(p_170466_, p_170468_);
        p_170467_.f_104203_ = Mth.m_144920_((float)-1.0471976f, (float)-0.2617994f, (float)((Mth.m_14031_((float)(-f)) + 1.0f) / 2.0f));
        p_170467_.f_104204_ = Mth.m_144920_((float)-0.7853982f, (float)0.7853982f, (float)((Mth.m_14031_((float)(-f + 1.0f)) + 1.0f) / 2.0f));
        if (p_170466_ == 1) {
            p_170467_.f_104204_ = (float)Math.PI - p_170467_.f_104204_;
        }
    }
}

