/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.codec.NullableFieldCodec;
import com.teamabnormals.blueprint.core.registry.BlueprintBiomes;
import com.teamabnormals.blueprint.core.util.registry.BasicRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;

public final class BiomeUtil {
    private static final Set<ResourceKey<Biome>> CUSTOM_END_MUSIC_BIOMES = new HashSet<ResourceKey<Biome>>();
    private static final BasicRegistry<Codec<? extends ModdedBiomeProvider>> MODDED_PROVIDERS = new BasicRegistry();
    public static final Codec<ResourceKey<Biome>> BIOME_KEY_CODEC = ResourceKey.m_195966_((ResourceKey)Registries.f_256952_);

    public static synchronized void registerBiomeProvider(ResourceLocation name, Codec<? extends ModdedBiomeProvider> codec) {
        MODDED_PROVIDERS.register(name, codec);
    }

    public static synchronized void markEndBiomeCustomMusic(ResourceKey<Biome> biomeName) {
        CUSTOM_END_MUSIC_BIOMES.add(biomeName);
    }

    public static boolean shouldPlayCustomEndMusic(ResourceKey<Biome> biomeName) {
        return CUSTOM_END_MUSIC_BIOMES.contains(biomeName);
    }

    static {
        MODDED_PROVIDERS.register(new ResourceLocation("blueprint", "original"), OriginalModdedBiomeProvider.CODEC);
        MODDED_PROVIDERS.register(new ResourceLocation("blueprint", "multi_noise"), MultiNoiseModdedBiomeProvider.CODEC);
        MODDED_PROVIDERS.register(new ResourceLocation("blueprint", "overlay"), OverlayModdedBiomeProvider.CODEC);
        MODDED_PROVIDERS.register(new ResourceLocation("blueprint", "biome_source"), BiomeSourceModdedBiomeProvider.CODEC);
    }

    public static enum OriginalModdedBiomeProvider implements ModdedBiomeProvider
    {
        INSTANCE;

        public static final Codec<OriginalModdedBiomeProvider> CODEC;
        private static final Set<Holder<Biome>> POSSIBLE_BIOMES;

        @Override
        public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler sampler, BiomeSource original, Registry<Biome> registry) {
            return original.m_203407_(x, y, z, sampler);
        }

        @Override
        public Codec<? extends ModdedBiomeProvider> codec() {
            return CODEC;
        }

        @Override
        public Set<Holder<Biome>> getAdditionalPossibleBiomes(Registry<Biome> registry) {
            return POSSIBLE_BIOMES;
        }

        static {
            CODEC = Codec.unit((Object)INSTANCE);
            POSSIBLE_BIOMES = ImmutableSet.of();
        }
    }

    public static class MultiNoiseModdedBiomeProvider
    implements ModdedBiomeProvider {
        private static final Codec<MultiNoiseModdedBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NullableFieldCodec.nullable("areas", Codec.unboundedMap(BIOME_KEY_CODEC, BIOME_KEY_CODEC), ImmutableMap.of()).forGetter(provider -> provider.areas), (App)Codec.either((Codec)MultiNoiseBiomeSourceParameterList.f_273930_, (Codec)ExtraCodecs.m_144637_((Codec)RecordCodecBuilder.create(pairInstance -> pairInstance.group((App)Climate.ParameterPoint.f_186862_.fieldOf("parameters").forGetter(Pair::getFirst), (App)BIOME_KEY_CODEC.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)pairInstance, Pair::of)).listOf())).fieldOf("biomes").forGetter(provider -> provider.rawBiomes), (App)Codec.BOOL.optionalFieldOf("only_map_from_areas", (Object)false).forGetter(provider -> provider.onlyMapFromAreas), (App)RegistryOps.m_255175_((ResourceKey)Registries.f_256952_)).apply((Applicative)instance, (areas, rawBiomes, onlyMapFromAreas, getter) -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            List biomes = (List)rawBiomes.map(preset -> ((MultiNoiseBiomeSourceParameterList)preset.m_203334_()).m_274385_().m_186850_().stream().map(pair -> Pair.of((Object)((Climate.ParameterPoint)pair.getFirst()), (Object)((ResourceKey)((Holder)pair.getSecond()).m_203543_().orElseThrow()))).toList(), list -> list);
            Holder.Reference originalSourceMarker = getter.m_255043_(BlueprintBiomes.ORIGINAL_SOURCE_MARKER);
            for (Pair pointWithKey : biomes) {
                ResourceKey key = (ResourceKey)pointWithKey.getSecond();
                ResourceKey keyForKey = (ResourceKey)areas.get(key);
                builder.add((Object)Pair.of((Object)((Climate.ParameterPoint)pointWithKey.getFirst()), (Object)(keyForKey != null ? getter.m_255043_(keyForKey) : (onlyMapFromAreas != false ? originalSourceMarker : (Holder)getter.m_254902_(key).orElse(originalSourceMarker)))));
            }
            return new MultiNoiseModdedBiomeProvider((Map<ResourceKey<Biome>, ResourceKey<Biome>>)areas, (Either<Holder<MultiNoiseBiomeSourceParameterList>, List<Pair<Climate.ParameterPoint, ResourceKey<Biome>>>>)rawBiomes, (Climate.ParameterList<Holder<Biome>>)new Climate.ParameterList((List)builder.build()), (boolean)onlyMapFromAreas);
        }));
        private final Map<ResourceKey<Biome>, ResourceKey<Biome>> areas;
        private final Either<Holder<MultiNoiseBiomeSourceParameterList>, List<Pair<Climate.ParameterPoint, ResourceKey<Biome>>>> rawBiomes;
        private final Climate.ParameterList<Holder<Biome>> biomes;
        private final boolean onlyMapFromAreas;

        private MultiNoiseModdedBiomeProvider(Map<ResourceKey<Biome>, ResourceKey<Biome>> areas, Either<Holder<MultiNoiseBiomeSourceParameterList>, List<Pair<Climate.ParameterPoint, ResourceKey<Biome>>>> rawBiomes, Climate.ParameterList<Holder<Biome>> biomes, boolean onlyMapFromAreas) {
            this.areas = areas;
            this.rawBiomes = rawBiomes;
            this.biomes = biomes;
            this.onlyMapFromAreas = onlyMapFromAreas;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler sampler, BiomeSource original, Registry<Biome> registry) {
            return (Holder)this.biomes.m_204252_(sampler.m_183445_(x, y, z));
        }

        @Override
        public Codec<? extends ModdedBiomeProvider> codec() {
            return CODEC;
        }

        @Override
        public Set<Holder<Biome>> getAdditionalPossibleBiomes(Registry<Biome> registry) {
            return this.biomes.m_186850_().stream().map(Pair::getSecond).collect(Collectors.toSet());
        }

        public static final class Builder {
            private final ImmutableMap.Builder<ResourceKey<Biome>, ResourceKey<Biome>> areas = ImmutableMap.builder();
            private Either<Holder<MultiNoiseBiomeSourceParameterList>, List<Pair<Climate.ParameterPoint, ResourceKey<Biome>>>> rawBiomes = Either.right((Object)ImmutableList.of());
            private boolean onlyMapFromAreas = true;

            public Builder area(ResourceKey<Biome> key, ResourceKey<Biome> value) {
                this.areas.put(key, value);
                return this;
            }

            public Builder biomes(Holder<MultiNoiseBiomeSourceParameterList> preset) {
                this.rawBiomes = Either.left(preset);
                return this;
            }

            public Builder biomes(Consumer<Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>>> consumer) {
                ImmutableList.Builder builder = ImmutableList.builder();
                consumer.accept(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                this.rawBiomes = Either.right((Object)builder.build());
                return this;
            }

            public Builder onlyMapFromAreas(boolean onlyMapFromAreas) {
                this.onlyMapFromAreas = onlyMapFromAreas;
                return this;
            }

            public MultiNoiseModdedBiomeProvider build() {
                return new MultiNoiseModdedBiomeProvider((Map<ResourceKey<Biome>, ResourceKey<Biome>>)this.areas.build(), this.rawBiomes, null, this.onlyMapFromAreas);
            }
        }
    }

    public record OverlayModdedBiomeProvider(List<Pair<HolderSet<Biome>, BiomeSource>> overlays) implements ModdedBiomeProvider
    {
        public static final Codec<OverlayModdedBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapPair((MapCodec)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256952_).fieldOf("matches_biomes"), (MapCodec)BiomeSource.f_47888_.fieldOf("biome_source")).codec().listOf().fieldOf("overlays").forGetter(provider -> provider.overlays)).apply((Applicative)instance, OverlayModdedBiomeProvider::new));

        @Override
        public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler sampler, BiomeSource original, Registry<Biome> registry) {
            Holder originalBiome = original.m_203407_(x, y, z, sampler);
            for (Pair<HolderSet<Biome>, BiomeSource> overlay : this.overlays) {
                if (!((HolderSet)overlay.getFirst()).m_203333_(originalBiome)) continue;
                return ((BiomeSource)overlay.getSecond()).m_203407_(x, y, z, sampler);
            }
            return registry.m_246971_(BlueprintBiomes.ORIGINAL_SOURCE_MARKER);
        }

        @Override
        public Set<Holder<Biome>> getAdditionalPossibleBiomes(Registry<Biome> registry) {
            HashSet<Holder<Biome>> biomes = new HashSet<Holder<Biome>>();
            this.overlays.forEach(overlay -> biomes.addAll(((BiomeSource)overlay.getSecond()).m_207840_()));
            return biomes;
        }

        @Override
        public Codec<? extends ModdedBiomeProvider> codec() {
            return CODEC;
        }
    }

    public record BiomeSourceModdedBiomeProvider(BiomeSource biomeSource) implements ModdedBiomeProvider
    {
        public static final Codec<BiomeSourceModdedBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(provider -> provider.biomeSource)).apply((Applicative)instance, BiomeSourceModdedBiomeProvider::new));

        @Override
        public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler sampler, BiomeSource original, Registry<Biome> registry) {
            return this.biomeSource.m_203407_(x, y, z, sampler);
        }

        @Override
        public Set<Holder<Biome>> getAdditionalPossibleBiomes(Registry<Biome> registry) {
            return this.biomeSource.m_207840_();
        }

        @Override
        public Codec<? extends ModdedBiomeProvider> codec() {
            return CODEC;
        }
    }

    public static interface ModdedBiomeProvider {
        public static final Codec<ModdedBiomeProvider> CODEC = MODDED_PROVIDERS.dispatchStable(ModdedBiomeProvider::codec, Function.identity());

        public Holder<Biome> getNoiseBiome(int var1, int var2, int var3, Climate.Sampler var4, BiomeSource var5, Registry<Biome> var6);

        public Set<Holder<Biome>> getAdditionalPossibleBiomes(Registry<Biome> var1);

        public Codec<? extends ModdedBiomeProvider> codec();
    }
}

