/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.compat.ITelemetry;
import com.qendolin.betterclouds.compat.TelemetryCache;
import com.qendolin.betterclouds.platform.ModVersion;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_3797;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class Telemetry
implements ITelemetry {
    public static final String ENDPOINT = "https://europe-west3-better-clouds.cloudfunctions.net/collect_telemetry";
    public static final int CONNECT_TIMEOUT_MS = 5000;
    public static final int READ_TIMEOUT_MS = 5000;
    public static final LocalDateTime EXPIRATION_DATE = LocalDateTime.of(2025, Month.JANUARY, 1, 0, 0);
    public static final int VERSION = 3;
    public static final String SHADER_COMPILE_ERROR = "SHADER_COMPILE_ERROR";
    public static final String SYSTEM_INFORMATION = "SYSTEM_INFORMATION";
    public static final String UNHANDLED_EXCEPTION = "UNHANDLED_EXCEPTION";
    public boolean enabled = true;
    protected final TelemetryCache cache = new TelemetryCache();
    protected final URL url;
    protected final Gson gson = new GsonBuilder().create();

    protected Telemetry(URL url) {
        this.url = url;
        if (LocalDateTime.now().isAfter(EXPIRATION_DATE)) {
            Main.LOGGER.info("Telemetry is expired, telemetry will not be sent");
            this.enabled = false;
        }
        if (Main.IS_DEV) {
            Main.LOGGER.info("Started in dev mode, telemetry will not be sent");
            this.enabled = false;
        }
    }

    @Override
    public CompletableFuture<Boolean> sendSystemInfo() {
        return this.sendPayload("", SYSTEM_INFORMATION);
    }

    protected CompletableFuture<Boolean> sendPayload(String payload, String ... labels) {
        if (!this.enabled) {
            return CompletableFuture.completedFuture(false);
        }
        try {
            RequestBody body = new RequestBody(new SystemDetails(), List.of(labels), payload, Main.getVersion(), 3);
            String json = this.gson.toJson((Object)body);
            byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
            return this.postAsync(bytes);
        }
        catch (Throwable e) {
            Main.LOGGER.error("Failed to send system information: ", e);
            return CompletableFuture.completedFuture(false);
        }
    }

    protected CompletableFuture<Boolean> postAsync(byte[] body) {
        return CompletableFuture.supplyAsync(() -> this.post(body));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean post(byte[] body) {
        boolean bl;
        OutputStream outputStream;
        block7: {
            HttpURLConnection conn = this.createConnection();
            if (conn == null) {
                return false;
            }
            outputStream = null;
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            conn.setRequestProperty("Content-Length", "" + body.length);
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            outputStream = conn.getOutputStream();
            Main.LOGGER.info("Sending telemetry, see https://github.com/Qendolin/better-clouds/blob/main/Telemetry.md for mor information");
            IOUtils.write((byte[])body, (OutputStream)outputStream);
            InputStreamReader is = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);
            String response = IOUtils.toString((Reader)is);
            if (response != null && response.trim().equalsIgnoreCase("ok")) break block7;
            Main.LOGGER.warn("Failed to post: bad request");
            boolean bl2 = false;
            IOUtils.closeQuietly((OutputStream)outputStream);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (Throwable e) {
            try {
                Main.LOGGER.error("Failed to post to telemetry endpoint: ", e);
                boolean bl3 = false;
                return bl3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(outputStream);
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return bl;
    }

    protected HttpURLConnection createConnection() {
        if (!this.enabled) {
            return null;
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setUseCaches(false);
            return connection;
        }
        catch (Throwable e) {
            Main.LOGGER.error("Failed to connect to telemetry endpoint: ", e);
            this.enabled = false;
            return null;
        }
    }

    @Override
    public void sendShaderCompileError(String error) {
        if (error == null || error.isBlank()) {
            return;
        }
        this.cachedSend(error, SHADER_COMPILE_ERROR);
    }

    private void cachedSend(String error, String messageType) {
        String hash;
        if (this.lazyOpenCache() && this.cache.contains(messageType, hash = this.cache.hash(error))) {
            return;
        }
        this.sendPayload(error, messageType).whenComplete((success, throwable) -> {
            if (success.booleanValue()) {
                String hash = this.cache.hash(error);
                this.cache.add(messageType, hash);
            }
        });
    }

    protected boolean lazyOpenCache() {
        if (!this.cache.isOpened()) {
            try {
                this.cache.open();
            }
            catch (IOException e) {
                Main.LOGGER.warn("Failed to open telemetry cache: ", (Throwable)e);
            }
        }
        return this.cache.isAvailable();
    }

    @Override
    public void sendUnhandledException(Exception e) {
        if (e == null) {
            return;
        }
        String message = ExceptionUtils.getStackTrace((Throwable)e);
        this.cachedSend(message, UNHANDLED_EXCEPTION);
    }

    @Override
    public void sendEvent(String key, String message) {
    }

    public static final class RequestBody {
        public final SystemDetails systemDetails;
        public final List<String> labels;
        public final String payload;
        public final int telemetryVersion;
        public final MetaInfo metaInfo;
        public final List<String> mods;

        public RequestBody(SystemDetails systemDetails, List<String> labels, String payload, ModVersion modVersion, int telemetryVersion) {
            this.systemDetails = systemDetails;
            this.labels = labels;
            this.payload = payload;
            this.telemetryVersion = telemetryVersion;
            this.metaInfo = new MetaInfo(modVersion);
            this.mods = List.of();
        }

        public static final class MetaInfo {
            public final ModVersion.SemVer modSemVer;
            public final String mcVersion;
            public final ModVersion.SemVer mcSemVer;
            public final String modVersion;

            public MetaInfo(ModVersion modVersion) {
                this.modVersion = modVersion.getFriendlyString();
                this.modSemVer = modVersion.asSemVer().orElse(null);
                this.mcVersion = class_3797.field_25319.method_48019();
                this.mcSemVer = ModVersion.fromString(class_3797.field_25319.method_48019()).asSemVer().orElse(null);
            }
        }
    }

    public static final class SystemDetails {
        public final String os = SystemUtils.OS_NAME;
        public final String vendor = Main.glCompat.getString(7936);
        public final String renderer = Main.glCompat.getString(7937);
        public final String glVersion = Main.glCompat.getString(7938);
        public final int glVersionMajor = Main.glCompat.getInteger(33307);
        public final int glVersionMinor = Main.glCompat.getInteger(33308);
        public final String glVersionCombined = String.format("%d%d", this.glVersionMajor, this.glVersionMinor);
        public final int glVersionLwjgl;
        public final String glslVersion;
        public final List<String> extensions;
        public final List<String> functions;
        public final List<String> fallbacks;
        public final String cpuName;
        public final boolean compatible;
        public final boolean partiallyIncompatible;

        public SystemDetails() {
            String cpuName;
            this.glVersionLwjgl = Main.glCompat.openGlMax;
            this.glslVersion = Main.glCompat.getString(35724);
            this.extensions = Main.glCompat.supportedCheckedExtensions;
            this.functions = Main.glCompat.supportedCheckedFunctions;
            this.fallbacks = Main.glCompat.usedFallbacks();
            this.compatible = !Main.glCompat.isIncompatible();
            this.partiallyIncompatible = Main.glCompat.isPartiallyIncompatible();
            try {
                CentralProcessor cpu = new SystemInfo().getHardware().getProcessor();
                cpuName = cpu.getProcessorIdentifier().getName().replaceAll("\\s+", " ");
            }
            catch (Exception ignored) {
                cpuName = "unavailable";
            }
            this.cpuName = cpuName;
        }
    }
}

