/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.compat.DistantHorizons2CompatImpl;
import com.qendolin.betterclouds.compat.DistantHorizons3CompatImpl;
import com.qendolin.betterclouds.compat.DistantHorizons4CompatImpl;
import com.qendolin.betterclouds.compat.DistantHorizonsCompatStub;
import com.qendolin.betterclouds.platform.ModLoader;
import com.seibel.distanthorizons.api.DhApi;
import java.util.Optional;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public abstract class DistantHorizonsCompat {
    public static final Matrix4f NOOP_MATRIX = new Matrix4f((Vector4fc)new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), (Vector4fc)new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), (Vector4fc)new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), (Vector4fc)new Vector4f(0.0f, 0.0f, -1.0f, 1.0f));
    private static DistantHorizonsCompat instance;

    public static void initialize() {
        if (instance != null) {
            return;
        }
        Main.LOGGER.info("Initializing DistantHorizons compat");
        boolean isLoaded = ModLoader.isModLoaded("distanthorizons");
        int apiVersion = 0;
        try {
            Class.forName("com.seibel.distanthorizons.api.DhApi");
            apiVersion = DhApi.getApiMajorVersion();
            Main.LOGGER.info("DistantHorizons API version is {}.{}.{}", DhApi.getApiMajorVersion(), DhApi.getApiMinorVersion(), DhApi.getApiPatchVersion());
        }
        catch (ClassNotFoundException e) {
            isLoaded = false;
        }
        if (isLoaded && apiVersion == 4) {
            Main.LOGGER.warn("Using EXPERIMENTAL DistantHorizons 4 compat. The game might crash!");
            instance = new DistantHorizons4CompatImpl();
        } else if (isLoaded && apiVersion == 3) {
            Main.LOGGER.info("Using DistantHorizons 3 compat");
            instance = new DistantHorizons3CompatImpl();
        } else if (isLoaded && apiVersion == 2) {
            Main.LOGGER.info("Using DistantHorizons 2 compat");
            instance = new DistantHorizons2CompatImpl();
        } else {
            Main.LOGGER.info("No DistantHorizons compat");
            instance = new DistantHorizonsCompatStub();
        }
    }

    public static DistantHorizonsCompat instance() {
        return instance;
    }

    public abstract boolean isReady();

    public abstract boolean isEnabled();

    public abstract Matrix4f getProjectionMatrix();

    public abstract Optional<Integer> getDepthTextureId();

    public abstract void disableLodClouds();
}

