/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.compat.DistantHorizonsSharedCompatImpl;
import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.interfaces.config.IDhApiConfigValue;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.api.objects.math.DhApiMat4f;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class DistantHorizons3CompatImpl
extends DistantHorizonsSharedCompatImpl {
    private Field dhProjectionMatrixField;
    private Method getValuesAsArrayMethod;

    public DistantHorizons3CompatImpl() {
        try {
            this.dhProjectionMatrixField = DhApiRenderParam.class.getField("dhProjectionMatrix");
            this.getValuesAsArrayMethod = DhApiMat4f.class.getMethod("getValuesAsArray", new Class[0]);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException("Your versions of Better Clouds and Distant Horizons are not compatible!", e);
        }
    }

    @Override
    public void disableLodClouds() {
        IDhApiConfigValue option = DhApi.Delayed.configs.graphics().genericRendering().cloudRenderingEnabled();
        option.setValue((Object)false);
    }

    @Override
    float[] getDhProjectionMatrixValues(DhApiRenderParam renderParam) {
        try {
            Object matrix = this.dhProjectionMatrixField.get(renderParam);
            Object values = this.getValuesAsArrayMethod.invoke(matrix, new Object[0]);
            return (float[])values;
        }
        catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Your versions of Better Clouds and Distant Horizons are not compatible!", e);
        }
    }
}

