/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qendolin.betterclouds.Config;
import com.qendolin.betterclouds.Main;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;

public class ShaderPresetLoader
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Config.ShaderConfigPreset.class, Config.ShaderConfigPreset.INSTANCE_CREATOR).create();
    public static final class_2960 ID = class_2960.method_43902((String)"betterclouds", (String)"shader_presets");
    public static final class_2960 RESOURCE_ID = class_2960.method_43902((String)"betterclouds", (String)"betterclouds/shader_presets.json");
    public static final ShaderPresetLoader INSTANCE = new ShaderPresetLoader();
    private Map<String, Config.ShaderConfigPreset> presets = null;

    public Map<String, Config.ShaderConfigPreset> presets() {
        if (this.presets == null) {
            return Map.of();
        }
        return ImmutableMap.copyOf(this.presets);
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 helper, class_3300 manager, class_3695 loadProfiler, class_3695 applyProfiler, Executor loadExecutor, Executor applyExecutor) {
        return ((CompletableFuture)this.load(manager, loadProfiler, loadExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)helper).method_18352(arg_0))).thenCompose(o -> this.apply((Map<String, Config.ShaderConfigPreset>)o, manager, applyProfiler, applyExecutor));
    }

    public CompletableFuture<Map<String, Config.ShaderConfigPreset>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap mergedPresets = new HashMap();
            Type mapType = new TypeToken<Map<String, Config.ShaderConfigPreset>>(){}.getType();
            for (class_3298 class_32982 : manager.method_14489(RESOURCE_ID)) {
                try {
                    BufferedReader reader = class_32982.method_43039();
                    try {
                        Map presets = (Map)GSON.fromJson((Reader)reader, mapType);
                        if (presets == null) continue;
                        mergedPresets.putAll(presets);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception exception) {
                    Main.LOGGER.warn("Failed to parse shader presets {} in pack '{}'", RESOURCE_ID, class_32982.method_45304().method_14409(), exception);
                }
            }
            mergedPresets.values().removeAll(Collections.singleton(null));
            for (Map.Entry entry : mergedPresets.entrySet()) {
                ((Config.ShaderConfigPreset)entry.getValue()).editable = false;
                ((Config.ShaderConfigPreset)entry.getValue()).key = (String)entry.getKey();
            }
            return mergedPresets;
        });
    }

    public CompletableFuture<Void> apply(Map<String, Config.ShaderConfigPreset> data, class_3300 manager, class_3695 profiler, Executor executor) {
        this.presets = data;
        if (Main.getConfig() != null) {
            Main.getConfig().loadDefaultPresets();
        }
        return CompletableFuture.completedFuture(null);
    }
}

